/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.IMySignature;
import anon.crypto.MyDSAPrivateKey;
import anon.crypto.MyDSAPublicKey;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import logging.LogHolder;
import logging.LogType;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.signers.DSASigner;

public final class MyDSASignature
implements IMySignature {
    private static final AlgorithmIdentifier ms_identifier = new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa_with_sha1);
    private DSASigner m_SignatureAlgorithm;
    private SHA1Digest m_Digest;

    public MyDSASignature() {
        try {
            this.m_SignatureAlgorithm = new DSASigner();
            this.m_Digest = new SHA1Digest();
        }
        catch (Exception exception) {
            this.m_SignatureAlgorithm = null;
        }
    }

    public synchronized void initVerify(IMyPublicKey iMyPublicKey) throws InvalidKeyException {
        try {
            MyDSAPublicKey myDSAPublicKey = (MyDSAPublicKey)iMyPublicKey;
            this.m_SignatureAlgorithm.init(false, myDSAPublicKey.getPublicParams());
            this.m_Digest.reset();
        }
        catch (Exception exception) {
            throw new InvalidKeyException("MyDSASignautre - initVerify - dont know how to hnalde the given key");
        }
    }

    public synchronized void initSign(IMyPrivateKey iMyPrivateKey) throws InvalidKeyException {
        try {
            MyDSAPrivateKey myDSAPrivateKey = (MyDSAPrivateKey)iMyPrivateKey;
            this.m_SignatureAlgorithm.init(true, myDSAPrivateKey.getPrivateParams());
        }
        catch (Exception exception) {
            throw new InvalidKeyException("MyDSASignautre - initVerify - dont know how to hnalde the given key");
        }
    }

    public synchronized boolean verify(byte[] byArray, int n, int n2, byte[] byArray2, int n3, int n4) {
        try {
            this.m_Digest.reset();
            this.m_Digest.update(byArray, n, n2);
            byte[] byArray3 = new byte[this.m_Digest.getDigestSize()];
            this.m_Digest.doFinal(byArray3, 0);
            BigInteger[] bigIntegerArray = MyDSASignature.derDecode(byArray2, n3, n4);
            return this.m_SignatureAlgorithm.verifySignature(byArray3, bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Throwable throwable) {
            LogHolder.log(7, LogType.CRYPTO, "Signature algorithm does not match!");
            return false;
        }
    }

    public synchronized boolean verify(byte[] byArray, byte[] byArray2) {
        return this.verify(byArray, 0, byArray.length, byArray2, 0, byArray2.length);
    }

    public synchronized byte[] sign(byte[] byArray) {
        try {
            this.m_Digest.reset();
            this.m_Digest.update(byArray, 0, byArray.length);
            byte[] byArray2 = new byte[this.m_Digest.getDigestSize()];
            this.m_Digest.doFinal(byArray2, 0);
            BigInteger[] bigIntegerArray = this.m_SignatureAlgorithm.generateSignature(byArray2);
            return MyDSASignature.derEncode(bigIntegerArray[0], bigIntegerArray[1]);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    public AlgorithmIdentifier getIdentifier() {
        return ms_identifier;
    }

    public byte[] encodeForXMLSignature(byte[] byArray) {
        int n;
        int n2 = byArray[3];
        int n3 = byArray[3 + n2 + 2];
        byte[] byArray2 = new byte[40];
        for (n = 0; n < 40; ++n) {
            byArray2[n] = 0;
        }
        n = 0;
        if (n2 == 21) {
            n = 1;
            n2 = 20;
        }
        System.arraycopy(byArray, 4 + n, byArray2, 20 - n2, n2);
        n2 = (byte)(n2 + n);
        int n4 = 0;
        if (n3 == 21) {
            n4 = 1;
            n3 = 20;
        }
        System.arraycopy(byArray, 4 + n2 + 2 + n4, byArray2, 40 - n3, n3);
        return byArray2;
    }

    public byte[] decodeForXMLSignature(byte[] byArray) {
        try {
            int n = 46;
            if (byArray[0] < 0) {
                ++n;
            }
            if (byArray[20] < 0) {
                ++n;
            }
            byte[] byArray2 = new byte[n];
            byArray2[0] = 48;
            byArray2[1] = (byte)(n - 2);
            byArray2[2] = 2;
            if (byArray[0] < 0) {
                n = 5;
                byArray2[3] = 21;
                byArray2[4] = 0;
            } else {
                byArray2[3] = 20;
                n = 4;
            }
            System.arraycopy(byArray, 0, byArray2, n, 20);
            n += 20;
            byArray2[n++] = 2;
            if (byArray[20] < 0) {
                byArray2[n++] = 21;
                byArray2[n++] = 0;
            } else {
                byArray2[n++] = 20;
            }
            System.arraycopy(byArray, 20, byArray2, n, 20);
            return byArray2;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String getXMLSignatureAlgorithmReference() {
        return "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
    }

    static byte[] derEncode(BigInteger bigInteger, BigInteger bigInteger2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DEROutputStream dEROutputStream = new DEROutputStream(byteArrayOutputStream);
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new ASN1Integer(bigInteger));
        aSN1EncodableVector.add(new ASN1Integer(bigInteger2));
        dEROutputStream.writeObject(new DERSequence(aSN1EncodableVector));
        return byteArrayOutputStream.toByteArray();
    }

    static BigInteger[] derDecode(byte[] byArray, int n, int n2) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray, n, n2);
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byteArrayInputStream);
        ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
        try {
            aSN1InputStream.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        BigInteger[] bigIntegerArray = new BigInteger[]{((ASN1Integer)aSN1Sequence.getObjectAt(0)).getValue(), ((ASN1Integer)aSN1Sequence.getObjectAt(1)).getValue()};
        return bigIntegerArray;
    }
}

