/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.crypto.IASymMixCipher;
import anon.crypto.MyRSA;
import anon.crypto.MyRSAPublicKey;
import anon.util.Base64;
import java.math.BigInteger;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ASymMixCipherPlainRSA
implements IASymMixCipher {
    MyRSA m_RSA = new MyRSA();
    private MyRSAPublicKey m_PublicKey = null;

    public int encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        byte[] byArray3 = null;
        try {
            byArray3 = this.m_RSA.processBlock(byArray, n, 128);
        }
        catch (Exception exception) {
            return -1;
        }
        if (byArray3.length == 128) {
            System.arraycopy(byArray3, 0, byArray2, n2, 128);
        } else if (byArray3.length == 129) {
            System.arraycopy(byArray3, 1, byArray2, n2, 128);
        } else {
            for (int i = 0; i < 128 - byArray3.length; ++i) {
                byArray2[n2 + i] = 0;
            }
            System.arraycopy(byArray3, 0, byArray2, n2 + 128 - byArray3.length, byArray3.length);
        }
        return 128;
    }

    public int getOutputBlockSize() {
        return 128;
    }

    public int getInputBlockSize() {
        return 128;
    }

    public int getPaddingSize() {
        return 0;
    }

    public int setPublicKey(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger == null || bigInteger2 == null) {
            return -1;
        }
        this.m_PublicKey = new MyRSAPublicKey(bigInteger, bigInteger2);
        try {
            this.m_RSA.init(this.m_PublicKey);
        }
        catch (Exception exception) {
            return -21;
        }
        return 0;
    }

    public int setPublicKey(Element element) {
        try {
            Element element2 = (Element)element.getElementsByTagName("RSAKeyValue").item(0);
            BigInteger bigInteger = this.getBigIntegerFromXml(element2, "Modulus");
            BigInteger bigInteger2 = this.getBigIntegerFromXml(element2, "Exponent");
            return this.setPublicKey(bigInteger, bigInteger2);
        }
        catch (Exception exception) {
            return -1;
        }
    }

    public MyRSAPublicKey getPublicKey() {
        return this.m_PublicKey;
    }

    private BigInteger getBigIntegerFromXml(Element element, String string) {
        try {
            Element element2 = (Element)element.getElementsByTagName(string).item(0);
            Text text = (Text)element2.getFirstChild();
            String string2 = text.getNodeValue();
            byte[] byArray = Base64.decode(string2);
            return new BigInteger(1, byArray);
        }
        catch (Exception exception) {
            return null;
        }
    }
}

