/*
 * Decompiled with CFR 0.152.
 */
package mixconfig;

import gui.dialog.JAPDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.IOException;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.border.EmptyBorder;
import mixconfig.MixConfig;
import mixconfig.MixConfiguration;
import mixconfig.panels.AdvancedPanel;
import mixconfig.panels.GeneralPanel;
import mixconfig.panels.LogCrimePanel;
import mixconfig.panels.MixConfigPanel;
import mixconfig.panels.NextMixProxyPanel;
import mixconfig.panels.OwnCertificatesPanel;
import mixconfig.panels.PaymentPanel;
import mixconfig.panels.PreviousMixPanel;
import mixconfig.panels.TermsAndConditionsPanel;

public class ConfigFrame
extends JPanel {
    private JTabbedPane m_tabbedPane;
    private MixConfigPanel[] m_panels = new MixConfigPanel[8];

    public ConfigFrame(JFrame parent) throws IOException {
        this.m_panels[0] = new GeneralPanel();
        this.m_panels[1] = new AdvancedPanel();
        this.m_panels[2] = new PaymentPanel();
        this.m_panels[3] = new OwnCertificatesPanel(parent == null);
        this.m_panels[4] = new PreviousMixPanel();
        this.m_panels[5] = new NextMixProxyPanel();
        this.m_panels[6] = TermsAndConditionsPanel.get();
        this.m_panels[7] = LogCrimePanel.get();
        this.m_tabbedPane = new JTabbedPane();
        for (int i = 0; i < this.m_panels.length; ++i) {
            this.m_tabbedPane.addTab(this.m_panels[i].getName(), this.m_panels[i]);
        }
        this.m_tabbedPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)this.m_tabbedPane, "Center");
        this.setConfiguration(MixConfig.getMixConfiguration());
    }

    protected void load() {
        try {
            for (int i = 0; i < this.m_panels.length; ++i) {
                this.m_panels[i].load();
            }
        }
        catch (Exception io) {
            JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), "Error while loading MixConfiguration", (Throwable)io);
        }
        if (!this.m_tabbedPane.getSelectedComponent().isEnabled()) {
            this.reset();
        }
    }

    protected void setActivePanel(Class a_panelClass) {
        if (a_panelClass == null) {
            return;
        }
        for (int i = 0; i < this.m_panels.length; ++i) {
            if (!this.m_panels[i].getClass().equals(a_panelClass)) continue;
            this.m_tabbedPane.setSelectedComponent(this.m_panels[i]);
            return;
        }
    }

    protected void reset() {
        this.m_tabbedPane.setSelectedComponent(this.m_panels[0]);
    }

    protected void setConfiguration(MixConfiguration m) throws IOException {
        if (m == null) {
            m = MixConfig.getMixConfiguration();
        } else {
            MixConfig.setMixConfiguration(m);
        }
        for (int i = 0; i < this.m_panels.length; ++i) {
            this.m_panels[i].setConfiguration(m);
        }
    }

    protected String[] check() throws IOException {
        Vector[] errors = new Vector[this.m_panels.length];
        this.setConfiguration(MixConfig.getMixConfiguration());
        for (int i = 0; i < this.m_panels.length; ++i) {
            errors[i] = this.m_panels[i].check();
            for (int j = 0; j < errors[i].size(); ++j) {
                errors[i].setElementAt(errors[i].elementAt(j) + " (" + this.m_panels[i].getName() + ")", j);
            }
        }
        int size = 0;
        for (int i = 0; i < errors.length; ++i) {
            if (!this.m_panels[i].isEnabled()) continue;
            size += errors[i].size();
        }
        String[] asString = new String[size];
        int k = 0;
        for (int j = 0; j < errors.length; ++j) {
            if (!this.m_panels[j].isEnabled()) continue;
            for (int i = 0; i < errors[j].size(); ++i) {
                asString[k++] = (String)errors[j].elementAt(i);
            }
        }
        return asString;
    }
}

