/*
 * Decompiled with CFR 0.152.
 */
package gui.help;

import anon.util.ClassUtil;
import gui.help.AbstractHelpFileStorageManager;
import java.io.File;
import java.util.Observable;

public class LocalHelpFileStorageManager
extends AbstractHelpFileStorageManager {
    private final Observable DUMMY = new Observable();
    private final String LOCAL_HELP_PATH;

    public LocalHelpFileStorageManager(String a_applicationName) {
        if (a_applicationName == null) {
            throw new IllegalArgumentException("Application name is null!");
        }
        File classDir = ClassUtil.getClassDirectory(this.getClass());
        this.LOCAL_HELP_PATH = classDir != null ? classDir.getParent() : null;
    }

    public boolean ensureMostRecentVersion(String helpPath) {
        return true;
    }

    public Observable getStorageObservable() {
        return this.DUMMY;
    }

    public boolean handleHelpPathChanged(String oldHelpPath, String newHelpPath, boolean a_bIgnoreExistingHelpDir) {
        return newHelpPath != null && newHelpPath.equals(this.LOCAL_HELP_PATH) && (oldHelpPath == null || !oldHelpPath.equals(newHelpPath));
    }

    public boolean helpInstallationExists(String helpPath) {
        return helpPath != null && helpPath.equals(this.LOCAL_HELP_PATH);
    }

    public String helpPathValidityCheck(String absolutePath, boolean a_bIgnoreExistingHelpDir) {
        if (absolutePath == null || !absolutePath.equals(this.LOCAL_HELP_PATH)) {
            return "invalidHelpPathNoWrite";
        }
        return "helpJonDoExists";
    }

    public String getInitPath() {
        return this.LOCAL_HELP_PATH;
    }
}

