/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.infoservice.AbstractDatabaseEntry;
import anon.infoservice.MessageDBEntry;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractMarkedMessageIDDBEntry
extends AbstractDatabaseEntry
implements IXMLEncodable {
    private long m_serial;
    private String m_id;
    private long m_creationTimeStamp;

    public AbstractMarkedMessageIDDBEntry(MessageDBEntry a_messageEntry) {
        super(Long.MAX_VALUE);
        this.m_serial = a_messageEntry.getVersionNumber();
        this.m_id = a_messageEntry.getId();
        this.m_creationTimeStamp = a_messageEntry.getLastUpdate();
    }

    public AbstractMarkedMessageIDDBEntry(Element a_messageEntryElement) throws XMLParseException {
        super(Long.MAX_VALUE);
        XMLUtil.assertNodeName(a_messageEntryElement, this.getXmlElementName());
        this.m_serial = XMLUtil.parseAttribute((Node)a_messageEntryElement, "serial", -1);
        this.m_id = XMLUtil.parseAttribute((Node)a_messageEntryElement, "id", null);
        this.m_creationTimeStamp = XMLUtil.parseAttribute((Node)a_messageEntryElement, "lastUpdate", System.currentTimeMillis());
        if (this.m_serial < 0L || this.m_id == null) {
            throw new XMLParseException(this.getXmlElementName(), "Illegal attribute values!");
        }
    }

    public abstract String getXmlElementName();

    public final long getVersionNumber() {
        return this.m_serial;
    }

    public final String getId() {
        return this.m_id;
    }

    public final long getLastUpdate() {
        return this.m_creationTimeStamp;
    }

    public final Element toXmlElement(Document a_doc) {
        if (a_doc == null) {
            return null;
        }
        Element elem = a_doc.createElement(this.getXmlElementName());
        XMLUtil.setAttribute(elem, "serial", this.m_serial);
        XMLUtil.setAttribute(elem, "id", this.m_id);
        XMLUtil.setAttribute(elem, "lastUpdate", this.m_creationTimeStamp);
        return elem;
    }
}

