/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.AuthSchemeNotImplException;
import HTTPClient.AuthorizationHandler;
import HTTPClient.AuthorizationInfo;
import HTTPClient.AuthorizationPrompter;
import HTTPClient.Codecs;
import HTTPClient.GlobalConstants;
import HTTPClient.HashVerifier;
import HTTPClient.HttpHeaderElement;
import HTTPClient.MD4;
import HTTPClient.MD5;
import HTTPClient.MD5InputStream;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.Response;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;
import HTTPClient.URI;
import HTTPClient.Util;
import ie.brd.crypto.algorithms.DES.DESAlgorithm;
import java.io.IOException;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class DefaultAuthHandler
implements AuthorizationHandler,
GlobalConstants {
    private static final byte[] NUL = new byte[0];
    private static final byte[] zeros = new byte[24];
    private static AuthorizationPrompter prompter = null;
    private static DESAlgorithm DES = new DESAlgorithm(false);
    private static byte[] digest_secret = null;
    private static String[] ordering = new String[]{"Digest", "NTLM", "Basic"};

    public AuthorizationInfo[] orderChallenges(AuthorizationInfo[] list, RoRequest req, RoResponse resp, boolean proxy) {
        int sidx;
        AuthorizationInfo[] new_list = new AuthorizationInfo[list.length];
        int nidx = 0;
        int oidx = 0;
        while (oidx < ordering.length) {
            sidx = 0;
            while (sidx < list.length) {
                if (list[sidx] != null && list[sidx].getScheme().equalsIgnoreCase(ordering[oidx])) {
                    new_list[nidx++] = list[sidx];
                    list[sidx] = null;
                }
                ++sidx;
            }
            ++oidx;
        }
        sidx = 0;
        while (sidx < list.length) {
            if (list[sidx] != null) {
                new_list[nidx++] = list[sidx];
            }
            ++sidx;
        }
        return new_list;
    }

    public AuthorizationInfo fixupAuthInfo(AuthorizationInfo info, Request req, AuthorizationInfo challenge, RoResponse resp, boolean proxy) throws AuthSchemeNotImplException {
        if (info.getScheme().equalsIgnoreCase("Basic") || info.getScheme().equalsIgnoreCase("SOCKS5")) {
            return info;
        }
        if (!info.getScheme().equalsIgnoreCase("Digest") && !info.getScheme().equalsIgnoreCase("NTLM")) {
            throw new AuthSchemeNotImplException(info.getScheme());
        }
        if (GlobalConstants.DebugAuth) {
            Util.logLine("Auth:  fixing up Authorization for host " + info.getHost() + ":" + info.getPort() + "; scheme: " + info.getScheme() + "; realm: " + info.getRealm());
        }
        if (info.getScheme().equalsIgnoreCase("Digest")) {
            return DefaultAuthHandler.digest_fixup(info, req, challenge, resp, proxy);
        }
        return DefaultAuthHandler.ntlm_fixup(info, req, challenge, resp);
    }

    public AuthorizationInfo getAuthorization(AuthorizationInfo challenge, RoRequest req, RoResponse resp, boolean proxy) throws AuthSchemeNotImplException {
        AuthorizationInfo cred;
        if (GlobalConstants.DebugAuth) {
            Util.logLine("Auth:  Requesting Authorization for host " + challenge.getHost() + ":" + challenge.getPort() + "; challenge: " + challenge);
        }
        if (!(challenge.getScheme().equalsIgnoreCase("Basic") || challenge.getScheme().equalsIgnoreCase("Digest") || challenge.getScheme().equalsIgnoreCase("NTLM") || challenge.getScheme().equalsIgnoreCase("SOCKS5"))) {
            throw new AuthSchemeNotImplException(challenge.getScheme());
        }
        if (challenge.getScheme().equalsIgnoreCase("Digest") ? (cred = DefaultAuthHandler.digest_check_stale(challenge, req, resp)) != null : challenge.getScheme().equalsIgnoreCase("NTLM") && (cred = DefaultAuthHandler.ntlm_check_step2(challenge, req, resp)) != null) {
            return cred;
        }
        if (prompter == null) {
            return null;
        }
        NVPair answer = prompter.getUsernamePassword(challenge);
        if (answer == null) {
            return null;
        }
        if (challenge.getScheme().equalsIgnoreCase("Basic")) {
            cred = DefaultAuthHandler.basic_gen_auth_info(challenge.getHost(), challenge.getPort(), challenge.getRealm(), answer.getName(), answer.getValue());
        } else if (challenge.getScheme().equalsIgnoreCase("Digest")) {
            cred = DefaultAuthHandler.digest_gen_auth_info(challenge.getHost(), challenge.getPort(), challenge.getRealm(), answer.getName(), answer.getValue(), req.getConnection().getContext());
            cred = DefaultAuthHandler.digest_fixup(cred, req, challenge, null, proxy);
        } else if (challenge.getScheme().equalsIgnoreCase("NTLM")) {
            cred = DefaultAuthHandler.ntlm_gen_auth_info(challenge.getHost(), challenge.getPort(), challenge.getRealm(), answer.getName(), answer.getValue());
            cred = DefaultAuthHandler.ntlm_fixup(cred, req, challenge, null);
        } else {
            cred = DefaultAuthHandler.socks5_gen_auth_info(challenge.getHost(), challenge.getPort(), challenge.getRealm(), answer.getName(), answer.getValue());
        }
        answer = null;
        System.gc();
        if (GlobalConstants.DebugAuth) {
            Util.logLine("Auth:  Got Authorization");
        }
        return cred;
    }

    public void handleAuthHeaders(Response resp, RoRequest req, AuthorizationInfo prev, AuthorizationInfo prxy) throws IOException {
        String auth_info = resp.getHeader("Authentication-Info");
        String prxy_info = resp.getHeader("Proxy-Authentication-Info");
        if (auth_info == null && prev != null && DefaultAuthHandler.hasParam(prev.getParams(), "qop", "auth-int")) {
            auth_info = "";
        }
        if (prxy_info == null && prxy != null && DefaultAuthHandler.hasParam(prxy.getParams(), "qop", "auth-int")) {
            prxy_info = "";
        }
        try {
            DefaultAuthHandler.handleAuthInfo(auth_info, "Authentication-Info", prev, resp, req, true);
            DefaultAuthHandler.handleAuthInfo(prxy_info, "Proxy-Authentication-Info", prxy, resp, req, true);
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
    }

    public void handleAuthTrailers(Response resp, RoRequest req, AuthorizationInfo prev, AuthorizationInfo prxy) throws IOException {
        String auth_info = resp.getTrailer("Authentication-Info");
        String prxy_info = resp.getTrailer("Proxy-Authentication-Info");
        try {
            DefaultAuthHandler.handleAuthInfo(auth_info, "Authentication-Info", prev, resp, req, false);
            DefaultAuthHandler.handleAuthInfo(prxy_info, "Proxy-Authentication-Info", prxy, resp, req, false);
        }
        catch (ParseException pe) {
            throw new IOException(pe.toString());
        }
    }

    private static void handleAuthInfo(String auth_info, String hdr_name, AuthorizationInfo prev, Response resp, RoRequest req, boolean in_headers) throws ParseException, IOException {
        if (auth_info == null) {
            return;
        }
        Vector pai = Util.parseHeader(auth_info);
        HttpHeaderElement elem = Util.getElement(pai, "nextnonce");
        if (DefaultAuthHandler.handle_nextnonce(prev, req, elem)) {
            pai.removeElement(elem);
        }
        if (DefaultAuthHandler.handle_discard(prev, req, elem = Util.getElement(pai, "discard"))) {
            pai.removeElement(elem);
        }
        if (in_headers) {
            HttpHeaderElement qop = null;
            if (pai != null && (qop = Util.getElement(pai, "qop")) != null && qop.getValue() != null) {
                DefaultAuthHandler.handle_rspauth(prev, resp, req, pai, hdr_name);
            } else if (prev != null && (Util.hasToken(resp.getHeader("Trailer"), hdr_name) && DefaultAuthHandler.hasParam(prev.getParams(), "qop", null) || DefaultAuthHandler.hasParam(prev.getParams(), "qop", "auth-int"))) {
                DefaultAuthHandler.handle_rspauth(prev, resp, req, null, hdr_name);
            } else if (pai != null && qop == null && pai.contains(new HttpHeaderElement("digest")) || Util.hasToken(resp.getHeader("Trailer"), hdr_name) && prev != null && !DefaultAuthHandler.hasParam(prev.getParams(), "qop", null)) {
                DefaultAuthHandler.handle_digest(prev, resp, req, hdr_name);
            }
        }
        if (pai.size() > 0) {
            resp.setHeader(hdr_name, Util.assembleHeader(pai));
        } else {
            resp.deleteHeader(hdr_name);
        }
    }

    private static final boolean hasParam(NVPair[] params, String name, String val) {
        int idx = 0;
        while (idx < params.length) {
            if (params[idx].getName().equalsIgnoreCase(name) && (val == null || params[idx].getValue().equalsIgnoreCase(val))) {
                return true;
            }
            ++idx;
        }
        return false;
    }

    public void addAuthorizationInfo(String scheme, String host, int port, String realm, Object name, Object passwd, Object context) throws AuthSchemeNotImplException {
        AuthorizationInfo info = null;
        if (scheme.equalsIgnoreCase("Basic")) {
            info = DefaultAuthHandler.basic_gen_auth_info(host, port, realm, (String)name, (String)passwd);
        } else if (scheme.equalsIgnoreCase("Digest")) {
            info = DefaultAuthHandler.digest_gen_auth_info(host, port, realm, (String)name, (String)passwd, context);
        } else if (scheme.equalsIgnoreCase("NTLM")) {
            info = DefaultAuthHandler.ntlm_gen_auth_info(host, port, realm, (String)name, (String)passwd);
        } else if (scheme.equalsIgnoreCase("SOCKS5")) {
            info = DefaultAuthHandler.socks5_gen_auth_info(host, port, realm, (String)name, (String)passwd);
        } else {
            throw new AuthSchemeNotImplException(scheme);
        }
        AuthorizationInfo.addAuthorization(info, context);
    }

    private static AuthorizationInfo basic_gen_auth_info(String host, int port, String realm, String user, String pass) {
        return new AuthorizationInfo(host, port, "Basic", realm, Codecs.base64Encode(user + ":" + pass));
    }

    private static AuthorizationInfo socks5_gen_auth_info(String host, int port, String realm, String user, String pass) {
        NVPair[] upwd = new NVPair[]{new NVPair(user, pass)};
        return new AuthorizationInfo(host, port, "SOCKS5", realm, upwd, null);
    }

    private static AuthorizationInfo digest_gen_auth_info(String host, int port, String realm, String user, String pass, Object context) {
        NVPair[] params;
        String A1 = user + ":" + realm + ":" + pass;
        String[] a1s = new String[]{new MD5(A1).asHex(), null};
        AuthorizationInfo prev = AuthorizationInfo.getAuthorization(host, port, "Digest", realm, context);
        if (prev == null) {
            params = new NVPair[]{new NVPair("username", user), new NVPair("uri", ""), new NVPair("nonce", ""), new NVPair("response", "")};
        } else {
            params = prev.getParams();
            int idx = 0;
            while (idx < params.length) {
                if (params[idx].getName().equalsIgnoreCase("username")) {
                    params[idx] = new NVPair("username", user);
                    break;
                }
                ++idx;
            }
        }
        return new AuthorizationInfo(host, port, "Digest", realm, params, a1s);
    }

    private static AuthorizationInfo digest_fixup(AuthorizationInfo info, RoRequest req, AuthorizationInfo challenge, RoResponse resp, boolean proxy) throws AuthSchemeNotImplException {
        AuthorizationInfo tmp;
        AuthorizationInfo new_info;
        String[] extra;
        NVPair[] params;
        int ch_domain = -1;
        int ch_nonce = -1;
        int ch_alg = -1;
        int ch_opaque = -1;
        int ch_stale = -1;
        int ch_dreq = -1;
        int ch_qop = -1;
        NVPair[] ch_params = null;
        if (challenge != null) {
            ch_params = challenge.getParams();
            int idx = 0;
            while (idx < ch_params.length) {
                String name = ch_params[idx].getName().toLowerCase();
                if (name.equals("domain")) {
                    ch_domain = idx;
                } else if (name.equals("nonce")) {
                    ch_nonce = idx;
                } else if (name.equals("opaque")) {
                    ch_opaque = idx;
                } else if (name.equals("algorithm")) {
                    ch_alg = idx;
                } else if (name.equals("stale")) {
                    ch_stale = idx;
                } else if (name.equals("digest-required")) {
                    ch_dreq = idx;
                } else if (name.equals("qop")) {
                    ch_qop = idx;
                }
                ++idx;
            }
        }
        int uri = -1;
        int user = -1;
        int alg = -1;
        int response = -1;
        int nonce = -1;
        int cnonce = -1;
        int nc = -1;
        int opaque = -1;
        int digest = -1;
        int dreq = -1;
        int qop = -1;
        AuthorizationInfo authorizationInfo = info;
        synchronized (authorizationInfo) {
            params = info.getParams();
            int idx = 0;
            while (idx < params.length) {
                String name = params[idx].getName().toLowerCase();
                if (name.equals("uri")) {
                    uri = idx;
                } else if (name.equals("username")) {
                    user = idx;
                } else if (name.equals("algorithm")) {
                    alg = idx;
                } else if (name.equals("nonce")) {
                    nonce = idx;
                } else if (name.equals("cnonce")) {
                    cnonce = idx;
                } else if (name.equals("nc")) {
                    nc = idx;
                } else if (name.equals("response")) {
                    response = idx;
                } else if (name.equals("opaque")) {
                    opaque = idx;
                } else if (name.equals("digest")) {
                    digest = idx;
                } else if (name.equals("digest-required")) {
                    dreq = idx;
                } else if (name.equals("qop")) {
                    qop = idx;
                }
                ++idx;
            }
            if (alg != -1 && !params[alg].getValue().equalsIgnoreCase("MD5") && !params[alg].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + params[alg].getValue() + " not implemented");
            }
            if (ch_alg != -1 && !ch_params[ch_alg].getValue().equalsIgnoreCase("MD5") && !ch_params[ch_alg].getValue().equalsIgnoreCase("MD5-sess")) {
                throw new AuthSchemeNotImplException("Digest auth scheme: Algorithm " + ch_params[ch_alg].getValue() + " not implemented");
            }
            params[uri] = new NVPair("uri", req.getRequestURI());
            String old_nonce = params[nonce].getValue();
            if (ch_nonce != -1 && !old_nonce.equals(ch_params[ch_nonce].getValue())) {
                params[nonce] = ch_params[ch_nonce];
            }
            if (ch_opaque != -1) {
                if (opaque == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    opaque = params.length - 1;
                }
                params[opaque] = ch_params[ch_opaque];
            }
            if (ch_alg != -1) {
                if (alg == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    alg = params.length - 1;
                }
                params[alg] = ch_params[ch_alg];
            }
            if (ch_qop != -1 || ch_alg != -1 && ch_params[ch_alg].getValue().equalsIgnoreCase("MD5-sess")) {
                if (cnonce == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    cnonce = params.length - 1;
                }
                if (digest_secret == null) {
                    digest_secret = DefaultAuthHandler.gen_random_bytes(20);
                }
                long l_time = System.currentTimeMillis();
                byte[] time = new byte[]{(byte)(l_time & 0xFFL), (byte)(l_time >> 8 & 0xFFL), (byte)(l_time >> 16 & 0xFFL), (byte)(l_time >> 24 & 0xFFL), (byte)(l_time >> 32 & 0xFFL), (byte)(l_time >> 40 & 0xFFL), (byte)(l_time >> 48 & 0xFFL), (byte)(l_time >> 56 & 0xFFL)};
                MD5 hash2 = new MD5(digest_secret);
                hash2.Update(time);
                params[cnonce] = new NVPair("cnonce", hash2.asHex());
            }
            if (ch_qop != -1) {
                if (qop == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    qop = params.length - 1;
                }
                String[] qops = Util.splitList(ch_params[ch_qop].getValue(), ",");
                String p = null;
                int idx2 = 0;
                while (idx2 < qops.length) {
                    if (qops[idx2].equalsIgnoreCase("auth-int") && req.getStream() == null) {
                        p = "auth-int";
                        break;
                    }
                    if (qops[idx2].equalsIgnoreCase("auth")) {
                        p = "auth";
                    }
                    ++idx2;
                }
                if (p == null) {
                    int idx3 = 0;
                    while (idx3 < qops.length) {
                        if (qops[idx3].equalsIgnoreCase("auth-int")) {
                            throw new AuthSchemeNotImplException("Digest auth scheme: Can't comply with qop option 'auth-int' because data not available");
                        }
                        ++idx3;
                    }
                    throw new AuthSchemeNotImplException("Digest auth scheme: None of the available qop options '" + ch_params[ch_qop].getValue() + "' implemented");
                }
                params[qop] = new NVPair("qop", p, false);
            }
            if (qop != -1) {
                if (nc == -1) {
                    params = Util.resizeArray(params, params.length + 1);
                    nc = params.length - 1;
                    params[nc] = new NVPair("nc", "00000001", false);
                } else if (old_nonce.equals(params[nonce].getValue())) {
                    String c = Long.toHexString(Long.parseLong(params[nc].getValue(), 16) + 1L);
                    params[nc] = new NVPair("nc", "00000000".substring(c.length()) + c, false);
                } else {
                    params[nc] = new NVPair("nc", "00000001", false);
                }
            }
            extra = (String[])info.getExtraInfo();
            if (challenge != null && (ch_stale == -1 || !ch_params[ch_stale].getValue().equalsIgnoreCase("true")) && alg != -1 && params[alg].getValue().equalsIgnoreCase("MD5-sess")) {
                extra[1] = new MD5(extra[0] + ":" + params[nonce].getValue() + ":" + params[cnonce].getValue()).asHex();
                info.setExtraInfo(extra);
            }
            info.setParams(params);
        }
        String A1 = alg != -1 && params[alg].getValue().equalsIgnoreCase("MD5-sess") ? extra[1] : extra[0];
        String A2 = req.getMethod() + ":" + params[uri].getValue();
        if (qop != -1 && params[qop].getValue().equalsIgnoreCase("auth-int")) {
            MD5 entity_hash = new MD5();
            entity_hash.Update(req.getData() == null ? NUL : req.getData());
            A2 = A2 + ":" + entity_hash.asHex();
        }
        A2 = new MD5(A2).asHex();
        String resp_val = qop == -1 ? new MD5(A1 + ":" + params[nonce].getValue() + ":" + A2).asHex() : new MD5(A1 + ":" + params[nonce].getValue() + ":" + params[nc].getValue() + ":" + params[cnonce].getValue() + ":" + params[qop].getValue() + ":" + A2).asHex();
        params[response] = new NVPair("response", resp_val);
        boolean ch_dreq_val = false;
        if (ch_dreq != -1 && (ch_params[ch_dreq].getValue() == null || ch_params[ch_dreq].getValue().equalsIgnoreCase("true"))) {
            ch_dreq_val = true;
        }
        if ((ch_dreq_val || digest != -1) && req.getStream() == null) {
            NVPair[] d_params;
            if (digest == -1) {
                d_params = Util.resizeArray(params, params.length + 1);
                digest = params.length;
            } else {
                d_params = params;
            }
            d_params[digest] = new NVPair("digest", DefaultAuthHandler.calc_digest(req, extra[0], params[nonce].getValue()));
            if (dreq == -1) {
                dreq = d_params.length;
                d_params = Util.resizeArray(d_params, d_params.length + 1);
                d_params[dreq] = new NVPair("digest-required", "true");
            }
            new_info = new AuthorizationInfo(info.getHost(), info.getPort(), info.getScheme(), info.getRealm(), d_params, extra);
        } else {
            new_info = ch_dreq_val ? null : new AuthorizationInfo(info.getHost(), info.getPort(), info.getScheme(), info.getRealm(), params, extra);
        }
        if (ch_domain != -1) {
            URI base = null;
            try {
                base = new URI(req.getConnection().getProtocol(), req.getConnection().getHost(), req.getConnection().getPort(), req.getRequestURI());
            }
            catch (ParseException pe) {
                // empty catch block
            }
            StringTokenizer tok = new StringTokenizer(ch_params[ch_domain].getValue());
            while (tok.hasMoreTokens()) {
                URI Uri;
                try {
                    Uri = new URI(base, tok.nextToken());
                }
                catch (ParseException pe) {
                    continue;
                }
                AuthorizationInfo tmp2 = AuthorizationInfo.getAuthorization(Uri.getHost(), Uri.getPort(), info.getScheme(), info.getRealm(), req.getConnection().getContext());
                if (tmp2 == null) {
                    params[uri] = new NVPair("uri", Uri.getPath());
                    tmp2 = new AuthorizationInfo(Uri.getHost(), Uri.getPort(), info.getScheme(), info.getRealm(), params, extra);
                    AuthorizationInfo.addAuthorization(tmp2);
                }
                if (proxy) continue;
                tmp2.addPath(Uri.getPath());
            }
        } else if (!proxy && challenge != null && (tmp = AuthorizationInfo.getAuthorization(challenge.getHost(), challenge.getPort(), info.getScheme(), info.getRealm(), req.getConnection().getContext())) != null) {
            tmp.addPath("/");
        }
        return new_info;
    }

    private static AuthorizationInfo digest_check_stale(AuthorizationInfo challenge, RoRequest req, RoResponse resp) throws AuthSchemeNotImplException {
        AuthorizationInfo cred = null;
        NVPair[] params = challenge.getParams();
        int idx = 0;
        while (idx < params.length) {
            String name = params[idx].getName();
            if (name.equalsIgnoreCase("stale") && params[idx].getValue().equalsIgnoreCase("true")) {
                cred = AuthorizationInfo.getAuthorization(challenge, req, resp, false, false);
                if (cred == null) break;
                return DefaultAuthHandler.digest_fixup(cred, req, challenge, resp, false);
            }
            ++idx;
        }
        return cred;
    }

    private static boolean handle_nextnonce(AuthorizationInfo prev, RoRequest req, HttpHeaderElement nextnonce) {
        AuthorizationInfo ai;
        if (prev == null || nextnonce == null || nextnonce.getValue() == null) {
            return false;
        }
        try {
            ai = AuthorizationInfo.getAuthorization(prev, req, null, false, false);
        }
        catch (AuthSchemeNotImplException asnie) {
            ai = prev;
        }
        AuthorizationInfo authorizationInfo = ai;
        synchronized (authorizationInfo) {
            NVPair[] params = ai.getParams();
            params = Util.setValue(params, "nonce", nextnonce.getValue());
            params = Util.setValue(params, "nc", "00000000", false);
            ai.setParams(params);
        }
        return true;
    }

    private static boolean handle_digest(AuthorizationInfo prev, Response resp, RoRequest req, String hdr_name) throws IOException {
        if (prev == null) {
            return false;
        }
        NVPair[] params = prev.getParams();
        VerifyDigest verifier = new VerifyDigest(((String[])prev.getExtraInfo())[0], Util.getValue(params, "nonce"), req.getMethod(), Util.getValue(params, "uri"), hdr_name, resp);
        if (resp.hasEntity()) {
            if (GlobalConstants.DebugAuth) {
                Util.logLine("Auth:  pushing md5-check-stream to verify digest from " + hdr_name);
            }
            resp.inp_stream = new MD5InputStream(resp.inp_stream, verifier);
        } else {
            if (GlobalConstants.DebugAuth) {
                Util.logLine("Auth:  verifying digest from " + hdr_name);
            }
            verifier.verifyHash(new MD5().Final(), 0L);
        }
        return true;
    }

    private static boolean handle_rspauth(AuthorizationInfo prev, Response resp, RoRequest req, Vector auth_info, String hdr_name) throws IOException {
        if (prev == null) {
            return false;
        }
        NVPair[] params = prev.getParams();
        int uri = -1;
        int alg = -1;
        int nonce = -1;
        int cnonce = -1;
        int nc = -1;
        int idx = 0;
        while (idx < params.length) {
            String name = params[idx].getName().toLowerCase();
            if (name.equals("uri")) {
                uri = idx;
            } else if (name.equals("algorithm")) {
                alg = idx;
            } else if (name.equals("nonce")) {
                nonce = idx;
            } else if (name.equals("cnonce")) {
                cnonce = idx;
            } else if (name.equals("nc")) {
                nc = idx;
            }
            ++idx;
        }
        VerifyRspAuth verifier = new VerifyRspAuth(params[uri].getValue(), ((String[])prev.getExtraInfo())[0], alg == -1 ? null : params[alg].getValue(), params[nonce].getValue(), cnonce == -1 ? "" : params[cnonce].getValue(), nc == -1 ? "" : params[nc].getValue(), hdr_name, resp);
        HttpHeaderElement qop = null;
        if (auth_info != null && (qop = Util.getElement(auth_info, "qop")) != null && qop.getValue() != null && (qop.getValue().equalsIgnoreCase("auth") || !resp.hasEntity() && qop.getValue().equalsIgnoreCase("auth-int"))) {
            if (GlobalConstants.DebugAuth) {
                Util.logLine("Auth:  verifying rspauth from " + hdr_name);
            }
            verifier.verifyHash(new MD5().Final(), 0L);
        } else {
            if (GlobalConstants.DebugAuth) {
                Util.logLine("Auth:  pushing md5-check-stream to verify rspauth from " + hdr_name);
            }
            resp.inp_stream = new MD5InputStream(resp.inp_stream, verifier);
        }
        return true;
    }

    private static String calc_digest(RoRequest req, String A1_hash, String nonce) {
        if (req.getStream() != null) {
            return "";
        }
        int ct = -1;
        int ce = -1;
        int lm = -1;
        int ex = -1;
        int dt = -1;
        int idx = 0;
        while (idx < req.getHeaders().length) {
            String name = req.getHeaders()[idx].getName();
            if (name.equalsIgnoreCase("Content-type")) {
                ct = idx;
            } else if (name.equalsIgnoreCase("Content-Encoding")) {
                ce = idx;
            } else if (name.equalsIgnoreCase("Last-Modified")) {
                lm = idx;
            } else if (name.equalsIgnoreCase("Expires")) {
                ex = idx;
            } else if (name.equalsIgnoreCase("Date")) {
                dt = idx;
            }
            ++idx;
        }
        NVPair[] hdrs = req.getHeaders();
        byte[] entity_body = req.getData() == null ? NUL : req.getData();
        MD5 entity_hash = new MD5();
        entity_hash.Update(entity_body);
        String entity_info = new MD5(req.getRequestURI() + ":" + (ct == -1 ? "" : hdrs[ct].getValue()) + ":" + entity_body.length + ":" + (ce == -1 ? "" : hdrs[ce].getValue()) + ":" + (lm == -1 ? "" : hdrs[lm].getValue()) + ":" + (ex == -1 ? "" : hdrs[ex].getValue())).asHex();
        String entity_digest = A1_hash + ":" + nonce + ":" + req.getMethod() + ":" + (dt == -1 ? "" : hdrs[dt].getValue()) + ":" + entity_info + ":" + entity_hash.asHex();
        if (GlobalConstants.DebugAuth) {
            Util.logLine("Auth:  Entity-Info: '" + req.getRequestURI() + ":" + (ct == -1 ? "" : hdrs[ct].getValue()) + ":" + entity_body.length + ":" + (ce == -1 ? "" : hdrs[ce].getValue()) + ":" + (lm == -1 ? "" : hdrs[lm].getValue()) + ":" + (ex == -1 ? "" : hdrs[ex].getValue()) + "'");
            Util.logLine("Auth:  Entity-Body: '" + entity_hash.asHex() + "'");
            Util.logLine("Auth:  Entity-Digest: '" + entity_digest + "'");
        }
        return new MD5(entity_digest).asHex();
    }

    private static boolean handle_discard(AuthorizationInfo prev, RoRequest req, HttpHeaderElement discard) {
        if (discard != null && prev != null) {
            AuthorizationInfo.removeAuthorization(prev, req.getConnection().getContext());
            return true;
        }
        return false;
    }

    private static byte[] gen_random_bytes(int num) {
        byte[] data = new byte[num];
        try {
            long fm = Runtime.getRuntime().freeMemory();
            data[0] = (byte)(fm & 0xFFL);
            data[1] = (byte)(fm >> 8 & 0xFFL);
            int h = data.hashCode();
            data[2] = (byte)(h & 0xFF);
            data[3] = (byte)(h >> 8 & 0xFF);
            data[4] = (byte)(h >> 16 & 0xFF);
            data[5] = (byte)(h >> 24 & 0xFF);
            long time = System.currentTimeMillis();
            data[6] = (byte)(time & 0xFFL);
            data[7] = (byte)(time >> 8 & 0xFFL);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return data;
    }

    private static AuthorizationInfo ntlm_gen_auth_info(String host, int port, String realm, String user, String pass) {
        int dot;
        byte[] lm_hpw = DefaultAuthHandler.calc_lm_hpw(pass);
        byte[] nt_hpw = DefaultAuthHandler.calc_ntcr_hpw(pass);
        String lhost = null;
        try {
            lhost = System.getProperty("HTTPClient.defAuthHandler.NTLM.host");
        }
        catch (SecurityException se) {
            // empty catch block
        }
        if (lhost == null) {
            try {
                lhost = InetAddress.getLocalHost().getHostName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (lhost == null) {
            lhost = "localhost";
        }
        if ((dot = lhost.indexOf(46)) != -1) {
            lhost = lhost.substring(0, dot);
        }
        String domain = null;
        int slash = user.indexOf(92);
        if (slash != -1) {
            domain = user.substring(0, slash);
        } else {
            try {
                domain = System.getProperty("HTTPClient.defAuthHandler.NTLM.domain");
            }
            catch (SecurityException se) {
                // empty catch block
            }
            if (domain == null) {
                domain = lhost;
            }
        }
        user = user.substring(slash + 1);
        Object[] info = new Object[]{user, lhost.toUpperCase().trim(), domain.toUpperCase().trim(), lm_hpw, nt_hpw};
        return new AuthorizationInfo(host, port, "NTLM", realm, null, info);
    }

    private static AuthorizationInfo ntlm_fixup(AuthorizationInfo info, RoRequest req, AuthorizationInfo challenge, RoResponse resp) throws AuthSchemeNotImplException {
        byte[] msg;
        if (challenge == null) {
            return info;
        }
        Object[] extra = (Object[])info.getExtraInfo();
        String user = (String)extra[0];
        String host = (String)extra[1];
        String dom = (String)extra[2];
        byte[] lm_hpw = (byte[])extra[3];
        byte[] nt_hpw = (byte[])extra[4];
        if (challenge.getCookie() == null) {
            msg = new byte[32 + host.length() + dom.length()];
            Util.getBytes("NTLMSSP", msg, 0);
            msg[8] = 1;
            int off = 32;
            msg[12] = 7;
            msg[13] = -78;
            int len = host.length();
            msg[24] = (byte)len;
            msg[25] = (byte)(len >> 8);
            msg[26] = (byte)len;
            msg[27] = (byte)(len >> 8);
            msg[28] = (byte)off;
            msg[29] = (byte)(off >> 8);
            Util.getBytes(host, len, msg, off);
            off += len;
            len = dom.length();
            msg[16] = (byte)len;
            msg[17] = (byte)(len >> 8);
            msg[18] = (byte)len;
            msg[19] = (byte)(len >> 8);
            msg[20] = (byte)off;
            msg[21] = (byte)(off >> 8);
            Util.getBytes(dom, len, msg, off);
            off += len;
        } else {
            String enc_msg = challenge.getCookie();
            byte[] tmp = enc_msg.getBytes();
            msg = Codecs.base64Decode(tmp);
            if (msg.length < 32) {
                throw new AuthSchemeNotImplException("NTLM auth scheme: Received invalid type-2 message (too short).");
            }
            byte[] expectedMessageStart = new byte[12];
            System.arraycopy(new String("NTLMSSP").getBytes(), 0, expectedMessageStart, 0, 7);
            expectedMessageStart[7] = 0;
            expectedMessageStart[8] = 2;
            expectedMessageStart[9] = 0;
            expectedMessageStart[10] = 0;
            expectedMessageStart[11] = 0;
            int i = 0;
            while (i < 12) {
                if (msg[i] != expectedMessageStart[i]) {
                    throw new AuthSchemeNotImplException("NTLM auth scheme: Received invalid type-2 message (Byte " + Integer.toString(i) + " is invalid.");
                }
                ++i;
            }
            boolean useUnicode = false;
            if ((msg[20] & 1) == 1) {
                useUnicode = true;
            }
            boolean ntlmSchemeSupported = false;
            if ((msg[21] & 2) == 2) {
                ntlmSchemeSupported = true;
            }
            byte[] nonce = new byte[8];
            System.arraycopy(msg, 24, nonce, 0, 8);
            int domainNameLength = dom.length();
            int userNameLength = user.length();
            int workstationNameLength = host.length();
            if (useUnicode) {
                domainNameLength = 2 * domainNameLength;
                userNameLength = 2 * userNameLength;
                workstationNameLength = 2 * workstationNameLength;
            }
            msg = new byte[64 + domainNameLength + userNameLength + workstationNameLength + 48];
            System.arraycopy(new String("NTLMSSP").getBytes(), 0, msg, 0, 7);
            msg[7] = 0;
            msg[8] = 3;
            msg[9] = 0;
            msg[10] = 0;
            msg[11] = 0;
            msg[12] = 24;
            msg[13] = 0;
            msg[14] = 24;
            msg[15] = 0;
            int lmOffset = msg.length - 48;
            msg[16] = (byte)lmOffset;
            msg[17] = (byte)(lmOffset >> 8);
            msg[18] = (byte)(lmOffset >> 16);
            msg[19] = (byte)(lmOffset >> 24);
            msg[20] = 24;
            msg[21] = 0;
            msg[22] = 24;
            msg[23] = 0;
            int ntlmOffset = msg.length - 24;
            msg[24] = (byte)ntlmOffset;
            msg[25] = (byte)(ntlmOffset >> 8);
            msg[26] = (byte)(ntlmOffset >> 16);
            msg[27] = (byte)(ntlmOffset >> 24);
            msg[28] = (byte)domainNameLength;
            msg[29] = (byte)(domainNameLength >> 8);
            msg[30] = (byte)domainNameLength;
            msg[31] = (byte)(domainNameLength >> 8);
            msg[32] = 64;
            msg[33] = 0;
            msg[34] = 0;
            msg[35] = 0;
            msg[36] = (byte)userNameLength;
            msg[37] = (byte)(userNameLength >> 8);
            msg[38] = (byte)userNameLength;
            msg[39] = (byte)(userNameLength >> 8);
            int userOffset = 64 + domainNameLength;
            msg[40] = (byte)userOffset;
            msg[41] = (byte)(userOffset >> 8);
            msg[42] = (byte)(userOffset >> 16);
            msg[43] = (byte)(userOffset >> 24);
            msg[44] = (byte)workstationNameLength;
            msg[45] = (byte)(workstationNameLength >> 8);
            msg[46] = (byte)workstationNameLength;
            msg[47] = (byte)(workstationNameLength >> 8);
            int workstationOffset = 64 + domainNameLength + userNameLength;
            msg[48] = (byte)workstationOffset;
            msg[49] = (byte)(workstationOffset >> 8);
            msg[50] = (byte)(workstationOffset >> 16);
            msg[51] = (byte)(workstationOffset >> 24);
            msg[52] = 0;
            msg[53] = 0;
            msg[54] = 0;
            msg[55] = 0;
            msg[56] = (byte)msg.length;
            msg[57] = (byte)(msg.length >> 8);
            msg[58] = (byte)(msg.length >> 16);
            msg[59] = (byte)(msg.length >> 24);
            msg[60] = useUnicode ? 1 : 2;
            msg[61] = ntlmSchemeSupported ? 2 : 0;
            msg[62] = 0;
            msg[63] = 0;
            if (useUnicode) {
                DefaultAuthHandler.writeUnicode(dom, msg, 64);
                DefaultAuthHandler.writeUnicode(user, msg, userOffset);
                DefaultAuthHandler.writeUnicode(host, msg, workstationOffset);
            } else {
                System.arraycopy(dom.getBytes(), 0, msg, 64, domainNameLength);
                System.arraycopy(user.getBytes(), 0, msg, userOffset, userNameLength);
                System.arraycopy(host.getBytes(), 0, msg, workstationOffset, workstationNameLength);
            }
            System.arraycopy(DefaultAuthHandler.calc_ntcr_resp(lm_hpw, nonce), 0, msg, lmOffset, 24);
            System.arraycopy(DefaultAuthHandler.calc_ntcr_resp(nt_hpw, nonce), 0, msg, ntlmOffset, 24);
        }
        String cookie = new String(Codecs.base64Encode(msg));
        AuthorizationInfo cred = new AuthorizationInfo(challenge.getHost(), challenge.getPort(), challenge.getScheme(), challenge.getRealm(), cookie);
        cred.setExtraInfo(extra);
        info.setCookie(cookie);
        return cred;
    }

    private static AuthorizationInfo ntlm_check_step2(AuthorizationInfo challenge, RoRequest req, RoResponse resp) throws AuthSchemeNotImplException {
        String auth = Util.getValue(req.getHeaders(), "Authorization");
        AuthorizationInfo cred = AuthorizationInfo.getAuthorization(challenge, req, resp, false, false);
        if (challenge.getCookie() != null && cred != null && auth != null && auth.startsWith("NTLM TlRMTVNTUAAB")) {
            return DefaultAuthHandler.ntlm_fixup(cred, req, challenge, null);
        }
        return null;
    }

    private static int writeUnicode(String str, byte[] buf, int off) {
        int len = str.length();
        int idx = 0;
        while (idx < len) {
            char c = str.charAt(idx);
            buf[off++] = (byte)c;
            buf[off++] = (byte)(c >> 8);
            ++idx;
        }
        return off;
    }

    private static byte[] calc_ntcr_hpw(String passw) {
        byte[] uc = new byte[passw.length() * 2];
        int idx = 0;
        int dst = 0;
        while (idx < passw.length()) {
            char ch = passw.charAt(idx);
            uc[dst++] = (byte)(ch & 0xFF);
            uc[dst++] = (byte)(ch >>> 8);
            ++idx;
        }
        byte[] hash2 = new MD4(uc).getHash();
        return Util.resizeArray(hash2, 21);
    }

    private static byte[] calc_lm_hpw(String passw) {
        passw = passw.toUpperCase();
        byte[] keys = new byte[14];
        Util.getBytes(passw, Math.min(passw.length(), 14), keys, 0);
        byte[] resp = new byte[21];
        byte[] magic = new byte[]{75, 71, 83, 33, 64, 35, 36, 37};
        byte[] crypt = new byte[8];
        int[] ks = DefaultAuthHandler.setup_key(keys, 0);
        DES.des_ecb_encrypt(magic, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 0, 8);
        ks = DefaultAuthHandler.setup_key(keys, 7);
        DES.des_ecb_encrypt(magic, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 8, 8);
        return resp;
    }

    private static byte[] calc_ntcr_resp(byte[] hpw, byte[] nonce) {
        byte[] resp = new byte[24];
        byte[] crypt = new byte[8];
        int[] ks = DefaultAuthHandler.setup_key(hpw, 0);
        DES.des_ecb_encrypt(nonce, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 0, 8);
        ks = DefaultAuthHandler.setup_key(hpw, 7);
        DES.des_ecb_encrypt(nonce, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 8, 8);
        ks = DefaultAuthHandler.setup_key(hpw, 14);
        DES.des_ecb_encrypt(nonce, crypt, ks, true);
        System.arraycopy(crypt, 0, resp, 16, 8);
        return resp;
    }

    private static int[] setup_key(byte[] k_56, int off) {
        byte[] key = new byte[8];
        int[] ks = new int[32];
        key[0] = k_56[off];
        key[1] = (byte)(k_56[off + 0] << 7 | (k_56[off + 1] & 0xFF) >> 1);
        key[2] = (byte)(k_56[off + 1] << 6 | (k_56[off + 2] & 0xFF) >> 2);
        key[3] = (byte)(k_56[off + 2] << 5 | (k_56[off + 3] & 0xFF) >> 3);
        key[4] = (byte)(k_56[off + 3] << 4 | (k_56[off + 4] & 0xFF) >> 4);
        key[5] = (byte)(k_56[off + 4] << 3 | (k_56[off + 5] & 0xFF) >> 5);
        key[6] = (byte)(k_56[off + 5] << 2 | (k_56[off + 6] & 0xFF) >> 6);
        key[7] = (byte)(k_56[off + 6] << 1);
        DES.des_set_odd_parity(key);
        DES.des_set_key(key, ks);
        return ks;
    }

    public static AuthorizationPrompter setAuthorizationPrompter(AuthorizationPrompter prompt) {
        AuthorizationPrompter prev = prompter;
        prompter = prompt;
        return prev;
    }

    private static final byte[] unHex(String hex) {
        byte[] digest = new byte[hex.length() / 2];
        int idx = 0;
        while (idx < digest.length) {
            digest[idx] = (byte)(0xFF & Integer.parseInt(hex.substring(2 * idx, 2 * (idx + 1)), 16));
            ++idx;
        }
        return digest;
    }

    private static String hex(byte[] buf) {
        StringBuffer str = new StringBuffer(buf.length * 3);
        int idx = 0;
        while (idx < buf.length) {
            str.append(Character.forDigit(buf[idx] >>> 4 & 0xF, 16));
            str.append(Character.forDigit(buf[idx] & 0xF, 16));
            str.append(':');
            ++idx;
        }
        str.setLength(str.length() - 1);
        return str.toString();
    }

    private static class VerifyDigest
    implements HashVerifier,
    GlobalConstants {
        private String HA1;
        private String nonce;
        private String method;
        private String uri;
        private String hdr;
        private RoResponse resp;

        public VerifyDigest(String HA1, String nonce, String method, String uri, String hdr, RoResponse resp) {
            this.HA1 = HA1;
            this.nonce = nonce;
            this.method = method;
            this.uri = uri;
            this.hdr = hdr;
            this.resp = resp;
        }

        public void verifyHash(byte[] hash2, long len) throws IOException {
            Vector pai;
            String auth_info = this.resp.getHeader(this.hdr);
            if (auth_info == null) {
                auth_info = this.resp.getTrailer(this.hdr);
            }
            if (auth_info == null) {
                return;
            }
            try {
                pai = Util.parseHeader(auth_info);
            }
            catch (ParseException pe) {
                throw new IOException(pe.toString());
            }
            HttpHeaderElement elem = Util.getElement(pai, "digest");
            if (elem == null || elem.getValue() == null) {
                return;
            }
            byte[] digest = DefaultAuthHandler.unHex(elem.getValue());
            String entity_info = new MD5(this.uri + ":" + this.header_val("Content-type", this.resp) + ":" + this.header_val("Content-length", this.resp) + ":" + this.header_val("Content-Encoding", this.resp) + ":" + this.header_val("Last-Modified", this.resp) + ":" + this.header_val("Expires", this.resp)).asHex();
            hash2 = new MD5(this.HA1 + ":" + this.nonce + ":" + this.method + ":" + this.header_val("Date", this.resp) + ":" + entity_info + ":" + MD5.asHex(hash2)).Final();
            int idx = 0;
            while (idx < hash2.length) {
                if (hash2[idx] != digest[idx]) {
                    throw new IOException("MD5-Digest mismatch: expected " + DefaultAuthHandler.hex(digest) + " but calculated " + DefaultAuthHandler.hex(hash2));
                }
                ++idx;
            }
            if (GlobalConstants.DebugAuth) {
                Util.logLine("Auth:  digest from " + this.hdr + "successfully verified");
            }
        }

        private final String header_val(String hdr_name, RoResponse resp) throws IOException {
            String hdr = resp.getHeader(hdr_name);
            String tlr = resp.getTrailer(hdr_name);
            return hdr != null ? hdr : (tlr != null ? tlr : "");
        }
    }

    private static class VerifyRspAuth
    implements HashVerifier,
    GlobalConstants {
        private String uri;
        private String HA1;
        private String alg;
        private String nonce;
        private String cnonce;
        private String nc;
        private String hdr;
        private RoResponse resp;

        public VerifyRspAuth(String uri, String HA1, String alg, String nonce, String cnonce, String nc, String hdr, RoResponse resp) {
            this.uri = uri;
            this.HA1 = HA1;
            this.alg = alg;
            this.nonce = nonce;
            this.cnonce = cnonce;
            this.nc = nc;
            this.hdr = hdr;
            this.resp = resp;
        }

        public void verifyHash(byte[] hash2, long len) throws IOException {
            String qop;
            Vector pai;
            String auth_info = this.resp.getHeader(this.hdr);
            if (auth_info == null) {
                auth_info = this.resp.getTrailer(this.hdr);
            }
            if (auth_info == null) {
                return;
            }
            try {
                pai = Util.parseHeader(auth_info);
            }
            catch (ParseException pe) {
                throw new IOException(pe.toString());
            }
            HttpHeaderElement elem = Util.getElement(pai, "qop");
            if (elem == null || (qop = elem.getValue()) == null || !qop.equalsIgnoreCase("auth") && !qop.equalsIgnoreCase("auth-int")) {
                return;
            }
            elem = Util.getElement(pai, "rspauth");
            if (elem == null || elem.getValue() == null) {
                return;
            }
            byte[] digest = DefaultAuthHandler.unHex(elem.getValue());
            elem = Util.getElement(pai, "cnonce");
            if (elem != null && elem.getValue() != null && !elem.getValue().equals(this.cnonce)) {
                throw new IOException("Digest auth scheme: received wrong client-nonce '" + elem.getValue() + "' - expected '" + this.cnonce + "'");
            }
            elem = Util.getElement(pai, "nc");
            if (elem != null && elem.getValue() != null && !elem.getValue().equals(this.nc)) {
                throw new IOException("Digest auth scheme: received wrong nonce-count '" + elem.getValue() + "' - expected '" + this.nc + "'");
            }
            String A1 = this.alg != null && this.alg.equalsIgnoreCase("MD5-sess") ? new MD5(this.HA1 + ":" + this.nonce + ":" + this.cnonce).asHex() : this.HA1;
            String A2 = ":" + this.uri;
            if (qop.equalsIgnoreCase("auth-int")) {
                A2 = A2 + ":" + MD5.asHex(hash2);
            }
            A2 = new MD5(A2).asHex();
            hash2 = new MD5(A1 + ":" + this.nonce + ":" + this.nc + ":" + this.cnonce + ":" + qop + ":" + A2).Final();
            int idx = 0;
            while (idx < hash2.length) {
                if (hash2[idx] != digest[idx]) {
                    throw new IOException("MD5-Digest mismatch: expected " + DefaultAuthHandler.hex(digest) + " but calculated " + DefaultAuthHandler.hex(hash2));
                }
                ++idx;
            }
            if (GlobalConstants.DebugAuth) {
                Util.logLine("Auth:  rspauth from " + this.hdr + " successfully verified");
            }
        }
    }
}

