/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.infoservice.Database;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.MixCascade;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.dialog.JAPDialog;
import gui.dialog.WorkerContentPane;
import jap.AbstractJAPConfModule;
import jap.JAPController;
import jap.JAPModel;
import jap.forward.JAPConfForwardingServerSavePoint;
import jap.forward.JAPRoutingConnectionClass;
import jap.forward.JAPRoutingForwardingModeSelector;
import jap.forward.JAPRoutingMessage;
import jap.forward.JAPRoutingSettings;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import logging.LogHolder;
import logging.LogType;

public class JAPConfForwardingServer
extends AbstractJAPConfModule {
    private DefaultListModel m_knownCascadesListModel;
    private DefaultListModel m_knownInfoServicesListModel;
    private DefaultListModel m_allowedCascadesListModel;
    private DefaultListModel m_registrationInfoServicesListModel;
    private JCheckBox m_startServerBox;
    private JTextField serverPortField;
    private JTextField uploadBandwidthField;
    private JComboBox connectionClassesComboBox;
    private JLabel settingsForwardingServerConfigCurrentBandwidthLabel;
    private JTextField relativeBandwidthField;
    private JButton increaseRelativeBandwidthButton;
    private JButton decreaseRelativeBandwidthButton;
    private JLabel settingsForwardingServerConfigAllowedCascadesKnownCascadesLabel;
    private JLabel settingsForwardingServerConfigAllowedCascadesAllowedCascadesLabel;
    private JList knownCascadesList;
    private JList allowedCascadesList;
    private JButton settingsForwardingServerConfigAllowedCascadesReloadButton;
    private JButton settingsForwardingServerConfigAllowedCascadesAddButton;
    private JButton settingsForwardingServerConfigAllowedCascadesRemoveButton;
    private JCheckBox settingsForwardingServerConfigAllowedCascadesAllowAllBox;
    private JLabel settingsForwardingServerConfigRegistrationInfoServicesKnownInfoServicesLabel;
    private JLabel settingsForwardingServerConfigRegistrationInfoServicesSelectedInfoServicesLabel;
    private JList knownInfoServicesList;
    private JList registrationInfoServicesList;
    private JButton settingsForwardingServerConfigRegistrationInfoServicesReloadButton;
    private JButton settingsForwardingServerConfigRegistrationInfoServicesAddButton;
    private JButton settingsForwardingServerConfigRegistrationInfoServicesRemoveButton;
    private JCheckBox settingsForwardingServerConfigRegistrationInfoServicesRegisterAtAllBox;
    private JComboBox forwardingModeComboBox;
    private JTextField skypeForwarderAddressField;
    private JLabel settingsRoutingForwardingModeLabel;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;

    public JAPConfForwardingServer() {
        super(new JAPConfForwardingServerSavePoint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initObservers() {
        if (super.initObservers()) {
            Object object = this.LOCK_OBSERVABLE;
            synchronized (object) {
                Observer forwardingModeSelectionObserver = new Observer(){

                    public void update(Observable a_notifier, Object a_message) {
                        try {
                            if (a_notifier == JAPModel.getInstance().getRoutingSettings().getForwardingModeSelector() && ((JAPRoutingMessage)a_message).getMessageCode() == 17) {
                                JAPRoutingForwardingModeSelector.TransportMode currentForwardingMode = JAPModel.getInstance().getRoutingSettings().getForwardingModeSelector().getCurrentForwardingMode();
                                LogHolder.log(7, LogType.GUI, "Routing mode set to " + currentForwardingMode.toString());
                                JAPConfForwardingServer.this.forwardingModeComboBox.setSelectedItem(currentForwardingMode);
                            }
                        }
                        catch (Exception e) {
                            LogHolder.log(2, LogType.GUI, e);
                        }
                    }
                };
                JAPModel.getInstance().getRoutingSettings().getForwardingModeSelector().addObserver(forwardingModeSelectionObserver);
                forwardingModeSelectionObserver.update(JAPModel.getInstance().getRoutingSettings().getForwardingModeSelector(), new JAPRoutingMessage(17));
                Observer skypeAddressObserver = new Observer(){

                    public void update(Observable a_notifier, Object a_message) {
                        try {
                            if (((JAPRoutingMessage)a_message).getMessageCode() == 18) {
                                JAPConfForwardingServer.this.skypeForwarderAddressField.setText(JAPModel.getInstance().getRoutingSettings().getSkypeForwarderAddress());
                            }
                        }
                        catch (Exception e) {
                            LogHolder.log(2, LogType.GUI, e);
                        }
                    }
                };
                JAPModel.getInstance().getRoutingSettings().addObserver(skypeAddressObserver);
                skypeAddressObserver.update(JAPModel.getInstance().getRoutingSettings(), new JAPRoutingMessage(18));
                Observer serverPortObserver = new Observer(){

                    public void update(Observable a_notifier, Object a_message) {
                        try {
                            if (a_notifier == JAPModel.getInstance().getRoutingSettings() && ((JAPRoutingMessage)a_message).getMessageCode() == 15) {
                                JTextField jTextField = JAPConfForwardingServer.this.serverPortField;
                                JAPModel.getInstance().getRoutingSettings();
                                jTextField.setText(Integer.toString(JAPRoutingSettings.getServerPort()));
                            }
                        }
                        catch (Exception e) {
                            LogHolder.log(2, LogType.GUI, e);
                        }
                    }
                };
                JAPModel.getInstance().getRoutingSettings().addObserver(serverPortObserver);
                serverPortObserver.update(JAPModel.getInstance().getRoutingSettings(), new JAPRoutingMessage(15));
                Observer connectionClassSelectionObserver = new Observer(){

                    public void update(Observable a_notifier, Object a_message) {
                        try {
                            if (a_notifier == JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector() && ((JAPRoutingMessage)a_message).getMessageCode() == 6) {
                                JAPRoutingConnectionClass currentConnectionClass = JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().getCurrentConnectionClass();
                                JAPConfForwardingServer.this.connectionClassesComboBox.setSelectedItem(currentConnectionClass);
                                if (currentConnectionClass.getIdentifier() == 8) {
                                    JAPConfForwardingServer.this.uploadBandwidthField.setEnabled(true);
                                } else {
                                    JAPConfForwardingServer.this.uploadBandwidthField.setEnabled(false);
                                }
                                JAPConfForwardingServer.this.uploadBandwidthField.setText(Integer.toString(currentConnectionClass.getMaximumBandwidth() * 8 / 1000));
                            }
                        }
                        catch (Exception e) {
                            LogHolder.log(2, LogType.GUI, e);
                        }
                    }
                };
                JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().addObserver(connectionClassSelectionObserver);
                connectionClassSelectionObserver.update(JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector(), new JAPRoutingMessage(6));
                Observer connectionClassSettingsObserver = new Observer(){

                    public void update(Observable a_notifier, Object a_message) {
                        try {
                            if (a_notifier == JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector()) {
                                if (((JAPRoutingMessage)a_message).getMessageCode() == 6 || ((JAPRoutingMessage)a_message).getMessageCode() == 7) {
                                    JAPRoutingConnectionClass currentConnectionClass = JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().getCurrentConnectionClass();
                                    JAPConfForwardingServer.this.relativeBandwidthField.setText(Integer.toString(currentConnectionClass.getRelativeBandwidth()) + "%");
                                    if (currentConnectionClass.getRelativeBandwidth() < 100) {
                                        JAPConfForwardingServer.this.increaseRelativeBandwidthButton.setEnabled(true);
                                    } else {
                                        JAPConfForwardingServer.this.increaseRelativeBandwidthButton.setEnabled(false);
                                    }
                                    if (currentConnectionClass.getRelativeBandwidth() > (currentConnectionClass.getMinimumRelativeBandwidth() + 9) / 10 * 10) {
                                        JAPConfForwardingServer.this.decreaseRelativeBandwidthButton.setEnabled(true);
                                    } else {
                                        JAPConfForwardingServer.this.decreaseRelativeBandwidthButton.setEnabled(false);
                                    }
                                }
                                if (((JAPRoutingMessage)a_message).getMessageCode() == 7) {
                                    JAPConfForwardingServer.this.settingsForwardingServerConfigCurrentBandwidthLabel.setText(JAPMessages.getString("settingsForwardingServerConfigCurrentBandwidthLabelPart1") + " " + Integer.toString(JAPModel.getInstance().getRoutingSettings().getBandwidth() * 8 / 1000) + " " + JAPMessages.getString("settingsForwardingServerConfigCurrentBandwidthLabelPart2") + " " + Integer.toString(JAPModel.getInstance().getRoutingSettings().getAllowedConnections()) + " " + JAPMessages.getString("settingsForwardingServerConfigCurrentBandwidthLabelPart3"));
                                }
                            }
                        }
                        catch (Exception e) {
                            LogHolder.log(2, LogType.GUI, e);
                        }
                    }
                };
                JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().addObserver(connectionClassSettingsObserver);
                connectionClassSettingsObserver.update(JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector(), new JAPRoutingMessage(7));
                Observer allowedMixCascadesObserver = new Observer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void update(Observable a_notifier, Object a_message) {
                        block9: {
                            try {
                                if (a_notifier != JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore()) break block9;
                                int messageCode = ((JAPRoutingMessage)a_message).getMessageCode();
                                if (messageCode == 9) {
                                    if (JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore().getAllowAllAvailableMixCascades()) {
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesKnownCascadesLabel.setEnabled(false);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesAllowedCascadesLabel.setEnabled(false);
                                        JAPConfForwardingServer.this.knownCascadesList.setEnabled(false);
                                        JAPConfForwardingServer.this.allowedCascadesList.setEnabled(false);
                                        JAPConfForwardingServer.this.knownCascadesList.setModel(new DefaultListModel());
                                        JAPConfForwardingServer.this.allowedCascadesList.setModel(new DefaultListModel());
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesReloadButton.setEnabled(false);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesAddButton.setEnabled(false);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesRemoveButton.setEnabled(false);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesAllowAllBox.setSelected(true);
                                    } else {
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesKnownCascadesLabel.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesAllowedCascadesLabel.setEnabled(true);
                                        JAPConfForwardingServer.this.knownCascadesList.setModel(JAPConfForwardingServer.this.m_knownCascadesListModel);
                                        JAPConfForwardingServer.this.allowedCascadesList.setModel(JAPConfForwardingServer.this.m_allowedCascadesListModel);
                                        JAPConfForwardingServer.this.knownCascadesList.setEnabled(true);
                                        JAPConfForwardingServer.this.allowedCascadesList.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesReloadButton.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesAddButton.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesRemoveButton.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesAllowAllBox.setSelected(false);
                                    }
                                }
                                if (messageCode != 10) break block9;
                                DefaultListModel defaultListModel = JAPConfForwardingServer.this.m_allowedCascadesListModel;
                                synchronized (defaultListModel) {
                                    JAPConfForwardingServer.this.m_allowedCascadesListModel.clear();
                                    Enumeration allowedCascades = JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore().getAllowedMixCascades().elements();
                                    while (allowedCascades.hasMoreElements()) {
                                        JAPConfForwardingServer.this.m_allowedCascadesListModel.addElement(allowedCascades.nextElement());
                                    }
                                }
                            }
                            catch (Exception e) {
                                LogHolder.log(2, LogType.GUI, e);
                            }
                        }
                    }
                };
                JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore().addObserver(allowedMixCascadesObserver);
                allowedMixCascadesObserver.update(JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore(), new JAPRoutingMessage(10));
                allowedMixCascadesObserver.update(JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore(), new JAPRoutingMessage(9));
                Observer registrationInfoServicesObserver = new Observer(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void update(Observable a_notifier, Object a_message) {
                        block9: {
                            try {
                                if (a_notifier != JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore()) break block9;
                                int messageCode = ((JAPRoutingMessage)a_message).getMessageCode();
                                if (messageCode == 11) {
                                    if (JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore().getRegisterAtAllAvailableInfoServices()) {
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesKnownInfoServicesLabel.setEnabled(false);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesSelectedInfoServicesLabel.setEnabled(false);
                                        JAPConfForwardingServer.this.knownInfoServicesList.setEnabled(false);
                                        JAPConfForwardingServer.this.registrationInfoServicesList.setEnabled(false);
                                        JAPConfForwardingServer.this.knownInfoServicesList.setModel(new DefaultListModel());
                                        JAPConfForwardingServer.this.registrationInfoServicesList.setModel(new DefaultListModel());
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesReloadButton.setEnabled(false);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesAddButton.setEnabled(false);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesRemoveButton.setEnabled(false);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesRegisterAtAllBox.setSelected(true);
                                    } else {
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesKnownInfoServicesLabel.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesSelectedInfoServicesLabel.setEnabled(true);
                                        JAPConfForwardingServer.this.knownInfoServicesList.setModel(JAPConfForwardingServer.this.m_knownInfoServicesListModel);
                                        JAPConfForwardingServer.this.registrationInfoServicesList.setModel(JAPConfForwardingServer.this.m_registrationInfoServicesListModel);
                                        JAPConfForwardingServer.this.knownInfoServicesList.setEnabled(true);
                                        JAPConfForwardingServer.this.registrationInfoServicesList.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesReloadButton.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesAddButton.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesRemoveButton.setEnabled(true);
                                        JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesRegisterAtAllBox.setSelected(false);
                                    }
                                }
                                if (messageCode != 12) break block9;
                                DefaultListModel defaultListModel = JAPConfForwardingServer.this.m_registrationInfoServicesListModel;
                                synchronized (defaultListModel) {
                                    JAPConfForwardingServer.this.m_registrationInfoServicesListModel.clear();
                                    Enumeration registrationInfoServices = JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore().getRegistrationInfoServices().elements();
                                    while (registrationInfoServices.hasMoreElements()) {
                                        JAPConfForwardingServer.this.m_registrationInfoServicesListModel.addElement(registrationInfoServices.nextElement());
                                    }
                                }
                            }
                            catch (Exception e) {
                                LogHolder.log(2, LogType.GUI, e);
                            }
                        }
                    }
                };
                JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore().addObserver(registrationInfoServicesObserver);
                registrationInfoServicesObserver.update(JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore(), new JAPRoutingMessage(12));
                registrationInfoServicesObserver.update(JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore(), new JAPRoutingMessage(11));
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recreateRootPanel() {
        JPanel rootPanel = this.getRootPanel();
        JAPConfForwardingServer jAPConfForwardingServer = this;
        synchronized (jAPConfForwardingServer) {
            rootPanel.removeAll();
            JPanel serverPanel = this.createForwardingServerConfigPanel();
            GridBagLayout rootPanelLayout = new GridBagLayout();
            rootPanel.setLayout(rootPanelLayout);
            GridBagConstraints rootPanelConstraints = new GridBagConstraints();
            rootPanelConstraints.anchor = 18;
            rootPanelConstraints.fill = 1;
            rootPanelConstraints.weightx = 1.0;
            rootPanelConstraints.weighty = 1.0;
            rootPanelConstraints.gridx = 0;
            rootPanelConstraints.gridy = 0;
            rootPanelLayout.setConstraints(serverPanel, rootPanelConstraints);
            rootPanel.add(serverPanel);
        }
    }

    public String getTabTitle() {
        return JAPMessages.getString("confTreeForwardingServerLeaf");
    }

    private JPanel createForwardingServerConfigPanel() {
        final JPanel configPanel = new JPanel();
        JLabel settingsForwardingServerConfigPortLabel = new JLabel(JAPMessages.getString("settingsForwardingServerConfigPortLabel"));
        JLabel settingsForwardingServerConfigSkypeAddressLabel = new JLabel(JAPMessages.getString("settingsForwardingServerConfigSkypeAddressLabel"));
        this.skypeForwarderAddressField = new JTextField(){
            private static final long serialVersionUID = 1L;

            protected Document createDefaultModel() {
                return new PlainDocument(){
                    private static final long serialVersionUID = 1L;

                    public void insertString(int a_position, String a_stringToInsert, AttributeSet a_attributes) throws BadLocationException {
                        try {
                            super.insertString(a_position, a_stringToInsert, a_attributes);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                };
            }
        };
        this.skypeForwarderAddressField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent afocusEvent) {
                try {
                    String newAddress = JAPConfForwardingServer.this.skypeForwarderAddressField.getText();
                    JAPModel.getInstance().getRoutingSettings().setSkypeForwarderAddress(newAddress);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        this.serverPortField = new JTextField(5){
            private static final long serialVersionUID = 1L;

            protected Document createDefaultModel() {
                return new PlainDocument(){
                    private static final long serialVersionUID = 1L;

                    public void insertString(int a_position, String a_stringToInsert, AttributeSet a_attributes) throws BadLocationException {
                        try {
                            int port = Integer.parseInt(this.getText(0, this.getLength()) + a_stringToInsert);
                            if (port >= 1 && port <= 65535) {
                                super.insertString(a_position, a_stringToInsert, a_attributes);
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                };
            }
        };
        this.serverPortField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent a_focusEvent) {
                try {
                    int port = Integer.parseInt(JAPConfForwardingServer.this.serverPortField.getText());
                    if (!JAPModel.getInstance().getRoutingSettings().setServerPort(port)) {
                        throw new Exception("Error while changing server port.");
                    }
                }
                catch (Exception e) {
                    JAPDialog.showErrorDialog((Component)configPanel, JAPMessages.getString("settingsForwardingServerConfigChangeServerPortError"));
                    JTextField jTextField = JAPConfForwardingServer.this.serverPortField;
                    JAPModel.getInstance().getRoutingSettings();
                    jTextField.setText(Integer.toString(JAPRoutingSettings.getServerPort()));
                }
            }
        });
        JLabel settingsRoutingForwardingModeLabel = new JLabel(JAPMessages.getString("settingsRoutingForwardingModeLabel"));
        this.forwardingModeComboBox = new JComboBox(JAPModel.getInstance().getRoutingSettings().getForwardingModeSelector().getForwardingModes());
        this.forwardingModeComboBox.setEditable(false);
        this.forwardingModeComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                LogHolder.log(7, LogType.GUI, "Action performed from forwardingModecomboBox");
                JAPModel.getInstance().getRoutingSettings().getForwardingModeSelector().setCurrentForwardingMode(((JAPRoutingForwardingModeSelector.TransportMode)JAPConfForwardingServer.this.forwardingModeComboBox.getSelectedItem()).getIdentifier());
            }
        });
        JLabel settingsForwardingServerConfigMyConnectionLabel = new JLabel(JAPMessages.getString("settingsForwardingServerConfigMyConnectionLabel"));
        this.connectionClassesComboBox = new JComboBox(JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().getConnectionClasses());
        this.connectionClassesComboBox.setEditable(false);
        this.connectionClassesComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().setCurrentConnectionClass(((JAPRoutingConnectionClass)JAPConfForwardingServer.this.connectionClassesComboBox.getSelectedItem()).getIdentifier());
            }
        });
        JLabel settingsForwardingServerConfigMaxUploadBandwidthLabel = new JLabel(JAPMessages.getString("settingsForwardingServerConfigMaxUploadBandwidthLabel"));
        this.uploadBandwidthField = new JTextField(){
            private static final long serialVersionUID = 1L;

            protected Document createDefaultModel() {
                return new PlainDocument(){
                    private static final long serialVersionUID = 1L;

                    public void insertString(int a_position, String a_stringToInsert, AttributeSet a_attributes) throws BadLocationException {
                        try {
                            int bandwidth = Integer.parseInt(this.getText(0, this.getLength()) + a_stringToInsert);
                            if (bandwidth >= 1) {
                                super.insertString(a_position, a_stringToInsert, a_attributes);
                            }
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                    }
                };
            }
        };
        this.uploadBandwidthField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent a_focusEvent) {
                try {
                    int bandwidth = Integer.parseInt(JAPConfForwardingServer.this.uploadBandwidthField.getText()) * 1000 / 8;
                    if (bandwidth < 4000) {
                        throw new Exception("JAPConfForwardingServer: Error while changing maximum upload bandwidth.");
                    }
                    JAPRoutingConnectionClass currentConnectionClass = JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().getCurrentConnectionClass();
                    currentConnectionClass.setMaximumBandwidth(bandwidth);
                    JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().setCurrentConnectionClass(currentConnectionClass.getIdentifier());
                }
                catch (Exception e) {
                    JAPDialog.showErrorDialog((Component)configPanel, JAPMessages.getString("settingsForwardingServerConfigChangeMaximumUploadBandwidthErrorPart1") + " " + Integer.toString(32) + " " + JAPMessages.getString("settingsForwardingServerConfigChangeMaximumUploadBandwidthErrorPart2"));
                    JAPConfForwardingServer.this.uploadBandwidthField.setText(Integer.toString(JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().getCurrentConnectionClass().getMaximumBandwidth() * 8 / 1000));
                }
            }
        });
        this.uploadBandwidthField.setColumns(7);
        JLabel settingsForwardingServerConfigForwardingPercentageLabel = new JLabel(JAPMessages.getString("settingsForwardingServerConfigForwardingPercentageLabel"));
        this.relativeBandwidthField = new JTextField();
        this.relativeBandwidthField.setColumns(4);
        this.relativeBandwidthField.setHorizontalAlignment(4);
        this.relativeBandwidthField.setDisabledTextColor(this.relativeBandwidthField.getForeground());
        this.relativeBandwidthField.setEnabled(false);
        this.increaseRelativeBandwidthButton = new JButton(GUIUtils.loadImageIcon("arrowUp.gif", true));
        this.increaseRelativeBandwidthButton.setBorder(new EmptyBorder(0, 1, 0, 1));
        this.increaseRelativeBandwidthButton.setFocusPainted(false);
        this.increaseRelativeBandwidthButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JAPRoutingConnectionClass currentConnectionClass = JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().getCurrentConnectionClass();
                int newRelativeBandwidth = Math.min(100, ((currentConnectionClass.getRelativeBandwidth() + 9) / 10 + 1) * 10);
                currentConnectionClass.setRelativeBandwidth(newRelativeBandwidth);
                JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().setCurrentConnectionClass(currentConnectionClass.getIdentifier());
            }
        });
        this.decreaseRelativeBandwidthButton = new JButton(GUIUtils.loadImageIcon("arrowDown.gif", true));
        this.decreaseRelativeBandwidthButton.setBorder(new EmptyBorder(0, 1, 0, 1));
        this.decreaseRelativeBandwidthButton.setFocusPainted(false);
        this.decreaseRelativeBandwidthButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JAPRoutingConnectionClass currentConnectionClass = JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().getCurrentConnectionClass();
                int newRelativeBandwidth = (Math.max(currentConnectionClass.getMinimumRelativeBandwidth(), currentConnectionClass.getRelativeBandwidth() - 10) + 9) / 10 * 10;
                currentConnectionClass.setRelativeBandwidth(newRelativeBandwidth);
                JAPModel.getInstance().getRoutingSettings().getConnectionClassSelector().setCurrentConnectionClass(currentConnectionClass.getIdentifier());
            }
        });
        this.settingsForwardingServerConfigCurrentBandwidthLabel = new JLabel();
        JTabbedPane advancedConfigurationTabPane = new JTabbedPane();
        advancedConfigurationTabPane.insertTab(JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesTabTitle"), null, this.createForwardingServerConfigAllowedCascadesPanel(), null, 0);
        advancedConfigurationTabPane.insertTab(JAPMessages.getString("settingsForwardingServerConfigRegistrationInfoServicesTabTitle"), null, this.createForwardingServerConfigRegistrationInfoServicesPanel(), null, 1);
        JPanel serverPortPanel = new JPanel();
        GridBagLayout serverPortPanelLayout = new GridBagLayout();
        serverPortPanel.setLayout(serverPortPanelLayout);
        GridBagConstraints serverPortPanelConstraints = new GridBagConstraints();
        serverPortPanelConstraints.anchor = 17;
        serverPortPanelConstraints.fill = 0;
        serverPortPanelConstraints.weightx = 0.0;
        serverPortPanelConstraints.weighty = 1.0;
        serverPortPanelConstraints.gridx = 0;
        serverPortPanelConstraints.gridy = 0;
        serverPortPanelConstraints.insets = new Insets(5, 5, 20, 5);
        serverPortPanelLayout.setConstraints(settingsForwardingServerConfigPortLabel, serverPortPanelConstraints);
        serverPortPanel.add(settingsForwardingServerConfigPortLabel);
        serverPortPanelConstraints.gridx = 1;
        serverPortPanelConstraints.gridy = 0;
        serverPortPanelConstraints.weightx = 1.0;
        serverPortPanelConstraints.insets = new Insets(5, 5, 20, 5);
        serverPortPanelLayout.setConstraints(this.serverPortField, serverPortPanelConstraints);
        serverPortPanel.add(this.serverPortField);
        serverPortPanelConstraints.anchor = 17;
        serverPortPanelConstraints.weightx = 0.0;
        serverPortPanelConstraints.weighty = 1.0;
        serverPortPanelConstraints.gridx = 2;
        serverPortPanelConstraints.gridy = 0;
        serverPortPanelConstraints.insets = new Insets(5, 0, 20, 5);
        serverPortPanelLayout.setConstraints(settingsForwardingServerConfigSkypeAddressLabel, serverPortPanelConstraints);
        serverPortPanel.add(settingsForwardingServerConfigSkypeAddressLabel);
        serverPortPanelConstraints.gridx = 3;
        serverPortPanelConstraints.gridy = 0;
        serverPortPanelConstraints.gridwidth = 4;
        serverPortPanelConstraints.insets = new Insets(5, 0, 20, 5);
        serverPortPanelLayout.setConstraints(this.skypeForwarderAddressField, serverPortPanelConstraints);
        serverPortPanel.add(this.skypeForwarderAddressField);
        this.m_startServerBox = new JCheckBox(JAPMessages.getString("forwardingServerStart"), JAPModel.getInstance().getRoutingSettings().getRoutingMode() == 2);
        serverPortPanelConstraints.gridx = 2;
        serverPortPanelConstraints.anchor = 12;
        this.m_startServerBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JAPController.getInstance().enableForwardingServer(JAPConfForwardingServer.this.m_startServerBox.isSelected());
            }
        });
        serverPortPanelConstraints.anchor = 18;
        TitledBorder settingsForwardingServerConfigBorder = new TitledBorder(JAPMessages.getString("settingsForwardingServerConfigBorder"));
        configPanel.setBorder(settingsForwardingServerConfigBorder);
        GridBagLayout configPanelLayout = new GridBagLayout();
        configPanel.setLayout(configPanelLayout);
        GridBagConstraints configPanelConstraints = new GridBagConstraints();
        configPanelConstraints.anchor = 18;
        configPanelConstraints.fill = 0;
        configPanelConstraints.gridx = 0;
        configPanelConstraints.gridy = 0;
        configPanelConstraints.gridwidth = 1;
        configPanelConstraints.weightx = 0.0;
        configPanelConstraints.insets = new Insets(0, 5, 0, 10);
        configPanelLayout.setConstraints(settingsRoutingForwardingModeLabel, configPanelConstraints);
        configPanel.add(settingsRoutingForwardingModeLabel);
        configPanelConstraints.gridx = 0;
        configPanelConstraints.gridy = 1;
        configPanelConstraints.weightx = 0.0;
        configPanelConstraints.gridwidth = 1;
        configPanelConstraints.gridheight = 1;
        configPanelConstraints.fill = 3;
        configPanelConstraints.anchor = 17;
        configPanelConstraints.insets = new Insets(0, 5, 10, 10);
        configPanelLayout.setConstraints(this.forwardingModeComboBox, configPanelConstraints);
        configPanel.add(this.forwardingModeComboBox);
        configPanelConstraints.fill = 1;
        configPanelConstraints.weightx = 1.0;
        configPanelConstraints.weighty = 0.0;
        configPanelConstraints.gridx = 0;
        configPanelConstraints.gridy = 2;
        configPanelConstraints.gridwidth = 4;
        configPanelLayout.setConstraints(serverPortPanel, configPanelConstraints);
        configPanel.add(serverPortPanel);
        configPanelConstraints.fill = 0;
        configPanelConstraints.gridx = 0;
        configPanelConstraints.gridy = 3;
        configPanelConstraints.gridwidth = 1;
        configPanelConstraints.weightx = 0.0;
        configPanelConstraints.insets = new Insets(0, 5, 0, 10);
        configPanelLayout.setConstraints(settingsForwardingServerConfigMyConnectionLabel, configPanelConstraints);
        configPanel.add(settingsForwardingServerConfigMyConnectionLabel);
        configPanelConstraints.gridx = 1;
        configPanelConstraints.gridy = 3;
        configPanelConstraints.insets = new Insets(0, 10, 0, 10);
        configPanelLayout.setConstraints(settingsForwardingServerConfigMaxUploadBandwidthLabel, configPanelConstraints);
        configPanel.add(settingsForwardingServerConfigMaxUploadBandwidthLabel);
        configPanelConstraints.gridx = 2;
        configPanelConstraints.gridy = 3;
        configPanelConstraints.gridwidth = 2;
        configPanelConstraints.weightx = 1.0;
        configPanelConstraints.insets = new Insets(0, 10, 0, 5);
        configPanelLayout.setConstraints(settingsForwardingServerConfigForwardingPercentageLabel, configPanelConstraints);
        configPanel.add(settingsForwardingServerConfigForwardingPercentageLabel);
        configPanelConstraints.gridx = 0;
        configPanelConstraints.gridy = 4;
        configPanelConstraints.weightx = 0.0;
        configPanelConstraints.gridwidth = 1;
        configPanelConstraints.gridheight = 1;
        configPanelConstraints.fill = 3;
        configPanelConstraints.anchor = 17;
        configPanelConstraints.insets = new Insets(0, 5, 10, 10);
        configPanelLayout.setConstraints(this.connectionClassesComboBox, configPanelConstraints);
        configPanel.add(this.connectionClassesComboBox);
        configPanelConstraints.gridx = 1;
        configPanelConstraints.gridy = 4;
        configPanelConstraints.insets = new Insets(0, 10, 10, 10);
        configPanelLayout.setConstraints(this.uploadBandwidthField, configPanelConstraints);
        configPanel.add(this.uploadBandwidthField);
        configPanelConstraints.gridx = 2;
        configPanelConstraints.gridy = 4;
        configPanelConstraints.fill = 1;
        configPanelConstraints.anchor = 17;
        configPanelConstraints.insets = new Insets(0, 10, 10, 0);
        configPanelLayout.setConstraints(this.relativeBandwidthField, configPanelConstraints);
        configPanel.add(this.relativeBandwidthField);
        JPanel pArrowButtons = new JPanel(new GridLayout(2, 1, 0, 0));
        pArrowButtons.add(this.increaseRelativeBandwidthButton);
        pArrowButtons.add(this.decreaseRelativeBandwidthButton);
        configPanelConstraints.gridx = 3;
        configPanelConstraints.gridy = 4;
        configPanelConstraints.weightx = 1.0;
        configPanelConstraints.fill = 3;
        configPanelConstraints.anchor = 16;
        configPanelConstraints.insets = new Insets(0, 0, 10, 5);
        configPanel.add((Component)pArrowButtons, configPanelConstraints);
        configPanelConstraints.gridx = 0;
        configPanelConstraints.gridy = 6;
        configPanelConstraints.weightx = 1.0;
        configPanelConstraints.gridwidth = 4;
        configPanelConstraints.insets = new Insets(0, 5, 20, 5);
        configPanelLayout.setConstraints(this.settingsForwardingServerConfigCurrentBandwidthLabel, configPanelConstraints);
        configPanel.add(this.settingsForwardingServerConfigCurrentBandwidthLabel);
        configPanelConstraints.gridx = 0;
        configPanelConstraints.gridy = 7;
        configPanelConstraints.weighty = 1.0;
        configPanelConstraints.fill = 1;
        configPanelConstraints.insets = new Insets(0, 5, 5, 5);
        configPanelLayout.setConstraints(advancedConfigurationTabPane, configPanelConstraints);
        configPanel.add(advancedConfigurationTabPane);
        return configPanel;
    }

    private JPanel createForwardingServerConfigAllowedCascadesPanel() {
        final JPanel allowedCascadesPanel = new JPanel();
        this.settingsForwardingServerConfigAllowedCascadesKnownCascadesLabel = new JLabel(JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesKnownCascadesLabel"));
        this.settingsForwardingServerConfigAllowedCascadesAllowedCascadesLabel = new JLabel(JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesAllowedCascadesLabel"));
        this.m_knownCascadesListModel = new DefaultListModel();
        this.m_knownInfoServicesListModel = new DefaultListModel();
        this.knownCascadesList = new JList(this.m_knownCascadesListModel);
        this.knownCascadesList.setSelectionMode(0);
        JScrollPane knownCascadesScrollPane = new JScrollPane(this.knownCascadesList);
        knownCascadesScrollPane.setPreferredSize(new JTextArea(4, 20).getPreferredSize());
        this.m_allowedCascadesListModel = new DefaultListModel();
        this.allowedCascadesList = new JList(this.m_allowedCascadesListModel);
        this.allowedCascadesList.setSelectionMode(0);
        JScrollPane allowedCascadesScrollPane = new JScrollPane(this.allowedCascadesList);
        allowedCascadesScrollPane.setPreferredSize(new JTextArea(4, 20).getPreferredSize());
        this.settingsForwardingServerConfigAllowedCascadesReloadButton = new JButton(JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesReloadButton"));
        this.settingsForwardingServerConfigAllowedCascadesReloadButton.addActionListener(new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent event) {
                DefaultListModel defaultListModel = JAPConfForwardingServer.this.m_knownCascadesListModel;
                synchronized (defaultListModel) {
                    JAPConfForwardingServer.this.m_knownCascadesListModel.clear();
                    Enumeration fetchedCascades = JAPConfForwardingServer.this.showFetchMixCascadesDialog(allowedCascadesPanel).elements();
                    while (fetchedCascades.hasMoreElements()) {
                        JAPConfForwardingServer.this.m_knownCascadesListModel.addElement(fetchedCascades.nextElement());
                    }
                }
            }
        });
        this.settingsForwardingServerConfigAllowedCascadesAddButton = new JButton(JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesAddButton"));
        this.settingsForwardingServerConfigAllowedCascadesAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MixCascade selectedCascade = (MixCascade)JAPConfForwardingServer.this.knownCascadesList.getSelectedValue();
                if (selectedCascade != null) {
                    JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore().addToAllowedMixCascades(selectedCascade);
                    JAPConfForwardingServer.this.m_knownCascadesListModel.removeElement(selectedCascade);
                }
            }
        });
        this.settingsForwardingServerConfigAllowedCascadesRemoveButton = new JButton(JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesRemoveButton"));
        this.settingsForwardingServerConfigAllowedCascadesRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                MixCascade selectedCascade = (MixCascade)JAPConfForwardingServer.this.allowedCascadesList.getSelectedValue();
                if (selectedCascade != null) {
                    JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore().removeFromAllowedMixCascades(selectedCascade.getId());
                    JAPConfForwardingServer.this.m_knownCascadesListModel.addElement(selectedCascade);
                }
            }
        });
        this.settingsForwardingServerConfigAllowedCascadesAllowAllBox = new JCheckBox(JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesAllowAllBox"), JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore().getAllowAllAvailableMixCascades());
        this.settingsForwardingServerConfigAllowedCascadesAllowAllBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JAPModel.getInstance().getRoutingSettings().getUseableMixCascadesStore().setAllowAllAvailableMixCascades(JAPConfForwardingServer.this.settingsForwardingServerConfigAllowedCascadesAllowAllBox.isSelected());
            }
        });
        TitledBorder settingsForwardingServerConfigAllowedCascadesBorder = new TitledBorder(JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesBorder"));
        allowedCascadesPanel.setBorder(settingsForwardingServerConfigAllowedCascadesBorder);
        GridBagLayout allowedCascadesPanelLayout = new GridBagLayout();
        allowedCascadesPanel.setLayout(allowedCascadesPanelLayout);
        GridBagConstraints allowedCascadesPanelConstraints = new GridBagConstraints();
        allowedCascadesPanelConstraints.anchor = 18;
        allowedCascadesPanelConstraints.fill = 0;
        allowedCascadesPanelConstraints.weightx = 1.0;
        allowedCascadesPanelConstraints.weighty = 0.0;
        allowedCascadesPanelConstraints.gridx = 0;
        allowedCascadesPanelConstraints.gridy = 0;
        allowedCascadesPanelConstraints.gridwidth = 2;
        allowedCascadesPanelConstraints.insets = new Insets(0, 5, 10, 5);
        allowedCascadesPanelLayout.setConstraints(this.settingsForwardingServerConfigAllowedCascadesAllowAllBox, allowedCascadesPanelConstraints);
        allowedCascadesPanel.add(this.settingsForwardingServerConfigAllowedCascadesAllowAllBox);
        allowedCascadesPanelConstraints.gridx = 0;
        allowedCascadesPanelConstraints.gridy = 1;
        allowedCascadesPanelConstraints.gridwidth = 1;
        allowedCascadesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        allowedCascadesPanelLayout.setConstraints(this.settingsForwardingServerConfigAllowedCascadesKnownCascadesLabel, allowedCascadesPanelConstraints);
        allowedCascadesPanel.add(this.settingsForwardingServerConfigAllowedCascadesKnownCascadesLabel);
        allowedCascadesPanelConstraints.gridx = 1;
        allowedCascadesPanelConstraints.gridy = 1;
        allowedCascadesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        allowedCascadesPanelLayout.setConstraints(this.settingsForwardingServerConfigAllowedCascadesAllowedCascadesLabel, allowedCascadesPanelConstraints);
        allowedCascadesPanel.add(this.settingsForwardingServerConfigAllowedCascadesAllowedCascadesLabel);
        allowedCascadesPanelConstraints.gridx = 0;
        allowedCascadesPanelConstraints.gridy = 2;
        allowedCascadesPanelConstraints.fill = 2;
        allowedCascadesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        allowedCascadesPanelLayout.setConstraints(this.settingsForwardingServerConfigAllowedCascadesReloadButton, allowedCascadesPanelConstraints);
        allowedCascadesPanel.add(this.settingsForwardingServerConfigAllowedCascadesReloadButton);
        allowedCascadesPanelConstraints.gridx = 0;
        allowedCascadesPanelConstraints.gridy = 3;
        allowedCascadesPanelConstraints.weighty = 1.0;
        allowedCascadesPanelConstraints.fill = 1;
        allowedCascadesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        allowedCascadesPanelLayout.setConstraints(knownCascadesScrollPane, allowedCascadesPanelConstraints);
        allowedCascadesPanel.add(knownCascadesScrollPane);
        allowedCascadesPanelConstraints.gridx = 1;
        allowedCascadesPanelConstraints.gridy = 2;
        allowedCascadesPanelConstraints.gridheight = 2;
        allowedCascadesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        allowedCascadesPanelLayout.setConstraints(allowedCascadesScrollPane, allowedCascadesPanelConstraints);
        allowedCascadesPanel.add(allowedCascadesScrollPane);
        allowedCascadesPanelConstraints.gridx = 0;
        allowedCascadesPanelConstraints.gridy = 4;
        allowedCascadesPanelConstraints.weighty = 0.0;
        allowedCascadesPanelConstraints.gridheight = 1;
        allowedCascadesPanelConstraints.fill = 2;
        allowedCascadesPanelConstraints.insets = new Insets(5, 5, 5, 5);
        allowedCascadesPanelLayout.setConstraints(this.settingsForwardingServerConfigAllowedCascadesAddButton, allowedCascadesPanelConstraints);
        allowedCascadesPanel.add(this.settingsForwardingServerConfigAllowedCascadesAddButton);
        allowedCascadesPanelConstraints.gridx = 1;
        allowedCascadesPanelConstraints.gridy = 4;
        allowedCascadesPanelConstraints.insets = new Insets(5, 5, 5, 5);
        allowedCascadesPanelLayout.setConstraints(this.settingsForwardingServerConfigAllowedCascadesRemoveButton, allowedCascadesPanelConstraints);
        allowedCascadesPanel.add(this.settingsForwardingServerConfigAllowedCascadesRemoveButton);
        return allowedCascadesPanel;
    }

    private JPanel createForwardingServerConfigRegistrationInfoServicesPanel() {
        JPanel registrationInfoServicesPanel = new JPanel();
        this.settingsForwardingServerConfigRegistrationInfoServicesKnownInfoServicesLabel = new JLabel(JAPMessages.getString("settingsForwardingServerConfigRegistrationInfoServicesKnownInfoServicesLabel"));
        this.settingsForwardingServerConfigRegistrationInfoServicesSelectedInfoServicesLabel = new JLabel(JAPMessages.getString("settingsForwardingServerConfigRegistrationInfoServicesSelectedInfoServicesLabel"));
        this.knownInfoServicesList = new JList(this.m_knownInfoServicesListModel);
        this.knownInfoServicesList.setSelectionMode(0);
        JScrollPane knownInfoServicesScrollPane = new JScrollPane(this.knownInfoServicesList);
        knownInfoServicesScrollPane.setPreferredSize(new JTextArea(4, 20).getPreferredSize());
        this.m_registrationInfoServicesListModel = new DefaultListModel();
        this.registrationInfoServicesList = new JList(this.m_registrationInfoServicesListModel);
        this.registrationInfoServicesList.setSelectionMode(0);
        JScrollPane registrationInfoServicesScrollPane = new JScrollPane(this.registrationInfoServicesList);
        registrationInfoServicesScrollPane.setPreferredSize(new JTextArea(4, 20).getPreferredSize());
        this.settingsForwardingServerConfigRegistrationInfoServicesReloadButton = new JButton(JAPMessages.getString("settingsForwardingServerConfigRegistrationInfoServicesReloadButton"));
        this.settingsForwardingServerConfigRegistrationInfoServicesReloadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JAPConfForwardingServer.this.startLoadInfoServicesThread();
            }
        });
        this.settingsForwardingServerConfigRegistrationInfoServicesAddButton = new JButton(JAPMessages.getString("settingsForwardingServerConfigRegistrationInfoServicesAddButton"));
        this.settingsForwardingServerConfigRegistrationInfoServicesAddButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                InfoServiceDBEntry selectedInfoService = (InfoServiceDBEntry)JAPConfForwardingServer.this.knownInfoServicesList.getSelectedValue();
                if (selectedInfoService != null) {
                    JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore().addToRegistrationInfoServices(selectedInfoService);
                    JAPConfForwardingServer.this.m_knownInfoServicesListModel.removeElement(selectedInfoService);
                }
            }
        });
        this.settingsForwardingServerConfigRegistrationInfoServicesRemoveButton = new JButton(JAPMessages.getString("settingsForwardingServerConfigRegistrationInfoServicesRemoveButton"));
        this.settingsForwardingServerConfigRegistrationInfoServicesRemoveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                InfoServiceDBEntry selectedInfoService = (InfoServiceDBEntry)JAPConfForwardingServer.this.registrationInfoServicesList.getSelectedValue();
                if (selectedInfoService != null) {
                    JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore().removeFromRegistrationInfoServices(selectedInfoService.getId());
                    JAPConfForwardingServer.this.m_knownInfoServicesListModel.addElement(selectedInfoService);
                }
            }
        });
        this.settingsForwardingServerConfigRegistrationInfoServicesRegisterAtAllBox = new JCheckBox(JAPMessages.getString("settingsForwardingServerConfigRegistrationInfoServicesRegisterAtAllBox"), JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore().getRegisterAtAllAvailableInfoServices());
        this.settingsForwardingServerConfigRegistrationInfoServicesRegisterAtAllBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent event) {
                JAPModel.getInstance().getRoutingSettings().getRegistrationInfoServicesStore().setRegisterAtAllAvailableInfoServices(JAPConfForwardingServer.this.settingsForwardingServerConfigRegistrationInfoServicesRegisterAtAllBox.isSelected());
            }
        });
        TitledBorder settingsForwardingServerConfigRegistrationInfoServicesBorder = new TitledBorder(JAPMessages.getString("settingsForwardingServerConfigRegistrationInfoServicesBorder"));
        registrationInfoServicesPanel.setBorder(settingsForwardingServerConfigRegistrationInfoServicesBorder);
        GridBagLayout registrationInfoServicesPanelLayout = new GridBagLayout();
        registrationInfoServicesPanel.setLayout(registrationInfoServicesPanelLayout);
        GridBagConstraints registrationInfoServicesPanelConstraints = new GridBagConstraints();
        registrationInfoServicesPanelConstraints.anchor = 18;
        registrationInfoServicesPanelConstraints.fill = 0;
        registrationInfoServicesPanelConstraints.weightx = 1.0;
        registrationInfoServicesPanelConstraints.weighty = 0.0;
        registrationInfoServicesPanelConstraints.gridx = 0;
        registrationInfoServicesPanelConstraints.gridy = 0;
        registrationInfoServicesPanelConstraints.gridwidth = 2;
        registrationInfoServicesPanelConstraints.insets = new Insets(0, 5, 10, 5);
        registrationInfoServicesPanelLayout.setConstraints(this.settingsForwardingServerConfigRegistrationInfoServicesRegisterAtAllBox, registrationInfoServicesPanelConstraints);
        registrationInfoServicesPanel.add(this.settingsForwardingServerConfigRegistrationInfoServicesRegisterAtAllBox);
        registrationInfoServicesPanelConstraints.gridx = 0;
        registrationInfoServicesPanelConstraints.gridy = 1;
        registrationInfoServicesPanelConstraints.gridwidth = 1;
        registrationInfoServicesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        registrationInfoServicesPanelLayout.setConstraints(this.settingsForwardingServerConfigRegistrationInfoServicesKnownInfoServicesLabel, registrationInfoServicesPanelConstraints);
        registrationInfoServicesPanel.add(this.settingsForwardingServerConfigRegistrationInfoServicesKnownInfoServicesLabel);
        registrationInfoServicesPanelConstraints.gridx = 1;
        registrationInfoServicesPanelConstraints.gridy = 1;
        registrationInfoServicesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        registrationInfoServicesPanelLayout.setConstraints(this.settingsForwardingServerConfigRegistrationInfoServicesSelectedInfoServicesLabel, registrationInfoServicesPanelConstraints);
        registrationInfoServicesPanel.add(this.settingsForwardingServerConfigRegistrationInfoServicesSelectedInfoServicesLabel);
        registrationInfoServicesPanelConstraints.gridx = 0;
        registrationInfoServicesPanelConstraints.gridy = 2;
        registrationInfoServicesPanelConstraints.fill = 2;
        registrationInfoServicesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        registrationInfoServicesPanelLayout.setConstraints(this.settingsForwardingServerConfigRegistrationInfoServicesReloadButton, registrationInfoServicesPanelConstraints);
        registrationInfoServicesPanel.add(this.settingsForwardingServerConfigRegistrationInfoServicesReloadButton);
        registrationInfoServicesPanelConstraints.gridx = 0;
        registrationInfoServicesPanelConstraints.gridy = 3;
        registrationInfoServicesPanelConstraints.weighty = 1.0;
        registrationInfoServicesPanelConstraints.fill = 1;
        registrationInfoServicesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        registrationInfoServicesPanelLayout.setConstraints(knownInfoServicesScrollPane, registrationInfoServicesPanelConstraints);
        registrationInfoServicesPanel.add(knownInfoServicesScrollPane);
        registrationInfoServicesPanelConstraints.gridx = 1;
        registrationInfoServicesPanelConstraints.gridy = 2;
        registrationInfoServicesPanelConstraints.gridheight = 2;
        registrationInfoServicesPanelConstraints.insets = new Insets(0, 5, 0, 5);
        registrationInfoServicesPanelLayout.setConstraints(registrationInfoServicesScrollPane, registrationInfoServicesPanelConstraints);
        registrationInfoServicesPanel.add(registrationInfoServicesScrollPane);
        registrationInfoServicesPanelConstraints.gridx = 0;
        registrationInfoServicesPanelConstraints.gridy = 4;
        registrationInfoServicesPanelConstraints.weighty = 0.0;
        registrationInfoServicesPanelConstraints.gridheight = 1;
        registrationInfoServicesPanelConstraints.insets = new Insets(5, 5, 5, 5);
        registrationInfoServicesPanelLayout.setConstraints(this.settingsForwardingServerConfigRegistrationInfoServicesAddButton, registrationInfoServicesPanelConstraints);
        registrationInfoServicesPanel.add(this.settingsForwardingServerConfigRegistrationInfoServicesAddButton);
        registrationInfoServicesPanelConstraints.gridx = 1;
        registrationInfoServicesPanelConstraints.gridy = 4;
        registrationInfoServicesPanelConstraints.insets = new Insets(5, 5, 5, 5);
        registrationInfoServicesPanelLayout.setConstraints(this.settingsForwardingServerConfigRegistrationInfoServicesRemoveButton, registrationInfoServicesPanelConstraints);
        registrationInfoServicesPanel.add(this.settingsForwardingServerConfigRegistrationInfoServicesRemoveButton);
        return registrationInfoServicesPanel;
    }

    private Vector showFetchMixCascadesDialog(JComponent a_parentComponent) {
        JAPDialog fetchMixCascadesDialog = new JAPDialog(a_parentComponent, JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesFetchMixCascadesDialogTitle"));
        fetchMixCascadesDialog.setResizable(false);
        fetchMixCascadesDialog.setDefaultCloseOperation(2);
        final Vector fetchedCascades = new Vector();
        final Vector errorOccured = new Vector();
        Runnable fetchMixCascadesThread = new Runnable(){

            public void run() {
                MixCascade cascade;
                Hashtable knownMixCascades = InfoServiceHolder.getInstance().getMixCascades();
                Thread.interrupted();
                if (knownMixCascades == null) {
                    errorOccured.addElement(new NullPointerException());
                    knownMixCascades = new Hashtable();
                }
                Enumeration cascades = knownMixCascades.elements();
                while (cascades.hasMoreElements()) {
                    cascade = (MixCascade)cascades.nextElement();
                    if (JAPConfForwardingServer.this.m_allowedCascadesListModel == null || JAPConfForwardingServer.this.m_allowedCascadesListModel.contains(cascade)) continue;
                    fetchedCascades.addElement(cascade);
                }
                cascades = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = JAPConfForwardingServer.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntrySnapshotAsEnumeration();
                while (cascades.hasMoreElements()) {
                    cascade = (MixCascade)cascades.nextElement();
                    if (!cascade.isUserDefined()) continue;
                    fetchedCascades.addElement(cascade);
                }
            }
        };
        WorkerContentPane worker = new WorkerContentPane(fetchMixCascadesDialog, JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesFetchMixCascadesDialogFetchLabel"), fetchMixCascadesThread);
        worker.updateDialog();
        fetchMixCascadesDialog.pack();
        fetchMixCascadesDialog.setVisible(true);
        if (errorOccured.size() > 0) {
            JAPDialog.showErrorDialog((Component)a_parentComponent, JAPMessages.getString("settingsForwardingServerConfigAllowedCascadesFetchMixCascadesDialogFetchCascadesError"));
        }
        return fetchedCascades;
    }

    public String getHelpContext() {
        return "forwarding_server";
    }

    protected void onRootPanelShown() {
        if (!JAPModel.isInfoServiceDisabled()) {
            this.fillLists();
        }
        this.m_startServerBox.setSelected(JAPModel.getInstance().getRoutingSettings().getRoutingMode() == 2);
    }

    private void fillLists() {
        this.m_knownCascadesListModel.clear();
        this.m_knownInfoServicesListModel.clear();
        Enumeration it = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = JAPConfForwardingServer.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntrySnapshotAsEnumeration();
        MixCascade currentCascade = JAPController.getInstance().getCurrentMixCascade();
        boolean bCurrentAlreadyAdded = false;
        while (it.hasMoreElements()) {
            MixCascade cascade = (MixCascade)it.nextElement();
            if (this.m_allowedCascadesListModel != null && !this.m_allowedCascadesListModel.contains(cascade)) {
                this.m_knownCascadesListModel.addElement(cascade);
            }
            if (!cascade.equals(currentCascade)) continue;
            bCurrentAlreadyAdded = true;
        }
        if (!bCurrentAlreadyAdded) {
            this.m_knownCascadesListModel.addElement(currentCascade);
        }
        this.startLoadInfoServicesThread();
    }

    private void startLoadInfoServicesThread() {
        Runnable doIt = new Runnable(){

            public void run() {
                JAPConfForwardingServer.this.loadInfoServices();
            }
        };
        Thread t = new Thread(doIt);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadInfoServices() {
        InfoServiceHolder infoServiceHolder = InfoServiceHolder.getInstance();
        synchronized (infoServiceHolder) {
            this.m_knownInfoServicesListModel.clear();
            Vector v = InfoServiceHolder.getInstance().getInfoservicesWithForwarderList();
            if (v != null) {
                Enumeration it = v.elements();
                while (it.hasMoreElements()) {
                    InfoServiceDBEntry is = (InfoServiceDBEntry)it.nextElement();
                    if (this.m_registrationInfoServicesListModel == null || this.m_registrationInfoServicesListModel.contains(is)) continue;
                    this.m_knownInfoServicesListModel.addElement(is);
                }
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

