/*
 * Decompiled with CFR 0.152.
 */
package jap;

import anon.infoservice.MixCascade;
import anon.pay.PayAccount;
import anon.platform.AbstractOS;
import anon.util.JAPMessages;
import gui.GUIUtils;
import gui.JAPMultilineLabel;
import gui.dialog.JAPDialog;
import gui.help.JAPHelp;
import jap.AbstractJAPMainView;
import jap.JAPConfCert;
import jap.JAPConfInfoService;
import jap.JAPConfModuleSystem;
import jap.JAPConfNetwork;
import jap.JAPConfServices;
import jap.JAPConfUI;
import jap.JAPConfUpdate;
import jap.JAPController;
import jap.JAPDebug;
import jap.JAPModel;
import jap.forward.JAPConfForwardingServer;
import jap.forward.JAPConfForwardingState;
import jap.pay.AccountSettingsPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import logging.LogHolder;
import logging.LogLevel;
import logging.LogType;

public final class JAPConf
extends JAPDialog
implements ActionListener,
WindowListener {
    public static final String MSG_READ_PANEL_HELP = (class$jap$JAPConf == null ? (class$jap$JAPConf = JAPConf.class$("jap.JAPConf")) : class$jap$JAPConf).getName() + "_readPanelHelp";
    private static final String MSG_DETAILLEVEL = (class$jap$JAPConf == null ? (class$jap$JAPConf = JAPConf.class$("jap.JAPConf")) : class$jap$JAPConf).getName() + "_detaillevel";
    private static final String MSG_BTN_SAVE = (class$jap$JAPConf == null ? (class$jap$JAPConf = JAPConf.class$("jap.JAPConf")) : class$jap$JAPConf).getName() + "_btnSave";
    private static final String MSG_ASK_RESET_DEFAULTS = (class$jap$JAPConf == null ? (class$jap$JAPConf = JAPConf.class$("jap.JAPConf")) : class$jap$JAPConf).getName() + "_askResetDefaults";
    private static final String MSG_NEED_RESTART = (class$jap$JAPConf == null ? (class$jap$JAPConf = JAPConf.class$("jap.JAPConf")) : class$jap$JAPConf).getName() + "_needRestart";
    private static final String MSG_COULD_NOT_OPEN_LOG = (class$jap$JAPConf == null ? (class$jap$JAPConf = JAPConf.class$("jap.JAPConf")) : class$jap$JAPConf).getName() + "_couldNotOpenLog";
    public static final String NETWORK_TAB = "NETWORK_TAB";
    public static final String UI_TAB = "UI_TAB";
    public static final String UPDATE_TAB = "UPDATE_TAB";
    public static final String PROXY_TAB = "PROXY_TAB";
    public static final String INFOSERVICE_TAB = "INFOSERVICE_TAB";
    public static final String ANON_TAB = "ANON_TAB";
    public static final String ANON_SERVICES_TAB = "SERVICES_TAB";
    public static final String ANON_TRUST_TAB = "ANON_TRUST_TAB";
    public static final String CERT_TAB = "CERT_TAB";
    public static final String TOR_TAB = "TOR_TAB";
    public static final String DEBUG_TAB = "DEBUG_TAB";
    public static final String PAYMENT_TAB = "PAYMENT_TAB";
    public static final String HTTP_FILTER_TAB = "HTTP_FILTER_TAB";
    public static final String FORWARDING_CLIENT_TAB = "FORWARDING_CLIENT_TAB";
    public static final String FORWARDING_SERVER_TAB = "FORWARDING_SERVER_TAB";
    public static final String FORWARDING_STATE_TAB = "FORWARDING_STATE_TAB";
    private static JAPConf ms_JapConfInstance = null;
    private JAPController m_Controller;
    private JCheckBox[] m_cbLogTypes;
    private JCheckBox m_cbShowDebugConsole;
    private JCheckBox m_cbDebugToFile;
    private JTextField m_tfDebugFileName;
    private JButton m_bttnDebugFileNameSearch;
    private JAPMultilineLabel m_labelConfDebugLevel;
    private JAPMultilineLabel m_labelConfDebugTypes;
    private JSlider m_sliderDebugLevel;
    private JSlider m_sliderDebugDetailLevel;
    private JPanel m_pMisc;
    private JButton m_bttnDefaultConfig;
    private JButton m_bttnCancel;
    private JButton m_bttnHelp;
    private boolean m_bWithPayment = false;
    private boolean m_bIsSimpleView;
    private Vector m_vecConfigChangesNeedRestart = new Vector();
    private JAPConfModuleSystem m_moduleSystem;
    private JAPConfServices m_confServices;
    private JAPConfInfoService m_confInfoService;
    private AbstractJAPMainView m_parentView;
    private AccountSettingsPanel m_accountSettings;
    private JAPConfUI m_confUI;
    static /* synthetic */ Class class$jap$JAPConf;

    public static JAPConf getInstance() {
        return ms_JapConfInstance;
    }

    public AbstractJAPMainView getMainView() {
        return this.m_parentView;
    }

    public JAPConf(AbstractJAPMainView frmParent, boolean loadPay) {
        super(frmParent, JAPMessages.getString("settingsDialog"), true);
        this.m_parentView = frmParent;
        this.setDefaultCloseOperation(1);
        this.m_bWithPayment = loadPay;
        this.m_bIsSimpleView = JAPModel.getDefaultView() == 2;
        ms_JapConfInstance = this;
        this.m_Controller = JAPController.getInstance();
        JPanel pContainer = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        pContainer.setLayout(gbl);
        this.m_pMisc = this.buildMiscPanel();
        this.m_moduleSystem = new JAPConfModuleSystem();
        DefaultMutableTreeNode rootNode = this.m_moduleSystem.getConfigurationTreeRootNode();
        this.m_confUI = new JAPConfUI();
        this.m_moduleSystem.addConfigurationModule(rootNode, this.m_confUI, UI_TAB);
        if (this.m_bWithPayment) {
            this.m_accountSettings = new AccountSettingsPanel();
            this.m_moduleSystem.addConfigurationModule(rootNode, this.m_accountSettings, PAYMENT_TAB);
        }
        if (!this.m_bIsSimpleView && !JAPController.getInstance().isHideUpdateDialogs()) {
            this.m_moduleSystem.addConfigurationModule(rootNode, new JAPConfUpdate(), UPDATE_TAB);
        }
        this.m_moduleSystem.addConfigurationModule(rootNode, new JAPConfNetwork(), NETWORK_TAB);
        this.m_confServices = new JAPConfServices();
        DefaultMutableTreeNode nodeAnon = this.m_moduleSystem.addComponent(rootNode, null, "ngTreeAnonService", null, null);
        if (!this.m_bIsSimpleView) {
            this.m_confInfoService = new JAPConfInfoService();
            this.m_moduleSystem.addConfigurationModule(nodeAnon, this.m_confServices, ANON_SERVICES_TAB);
            this.m_moduleSystem.addConfigurationModule(nodeAnon, this.m_confInfoService, INFOSERVICE_TAB);
            this.m_moduleSystem.addConfigurationModule(nodeAnon, new JAPConfForwardingServer(), FORWARDING_SERVER_TAB);
            this.m_moduleSystem.addConfigurationModule(nodeAnon, new JAPConfCert(), CERT_TAB);
            DefaultMutableTreeNode debugNode = this.m_moduleSystem.addComponent(rootNode, this.m_pMisc, "ngTreeDebugging", DEBUG_TAB, "debugging");
            if (JAPModel.getInstance().isForwardingStateModuleVisible()) {
                this.m_moduleSystem.addConfigurationModule(debugNode, new JAPConfForwardingState(), FORWARDING_STATE_TAB);
            }
        } else {
            this.m_moduleSystem.addConfigurationModule(nodeAnon, this.m_confServices, ANON_SERVICES_TAB);
        }
        this.m_moduleSystem.getConfigurationTree().expandPath(new TreePath(nodeAnon.getPath()));
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.m_bttnHelp = new JButton(JAPMessages.getString(JAPHelp.MSG_HELP_BUTTON));
        buttonPanel.add(this.m_bttnHelp);
        this.m_bttnHelp.addActionListener(this);
        this.m_bttnDefaultConfig = new JButton(JAPMessages.getString("bttnDefaultConfig"));
        final JAPConf view = this;
        this.m_bttnDefaultConfig.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (JAPDialog.showConfirmDialog(view, JAPMessages.getString(MSG_ASK_RESET_DEFAULTS), 2, 2) == 0) {
                    JAPConf.this.resetToDefault();
                }
            }
        });
        if (!JAPModel.isSmallDisplay()) {
            buttonPanel.add(this.m_bttnDefaultConfig);
        }
        this.m_bttnCancel = new JButton(JAPMessages.getString("cancelButton"));
        this.m_bttnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JAPConf.this.cancelPressed();
            }
        });
        buttonPanel.add(this.m_bttnCancel);
        JButton bttnSave = new JButton(JAPMessages.getString(MSG_BTN_SAVE));
        bttnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JAPConf.this.okPressed(false);
            }
        });
        buttonPanel.add(bttnSave);
        JButton ok = new JButton(JAPMessages.getString("okButton"));
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JAPConf.this.okPressed(true);
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(new JLabel("   "));
        this.getRootPane().setDefaultButton(ok);
        JPanel moduleSystemPanel = this.m_moduleSystem.getRootPanel();
        GridBagLayout configPanelLayout = new GridBagLayout();
        pContainer.setLayout(configPanelLayout);
        GridBagConstraints configPanelConstraints = new GridBagConstraints();
        configPanelConstraints.anchor = 18;
        configPanelConstraints.fill = 1;
        configPanelConstraints.weightx = 1.0;
        configPanelConstraints.weighty = 1.0;
        configPanelConstraints.gridx = 0;
        configPanelConstraints.gridy = 0;
        configPanelLayout.setConstraints(moduleSystemPanel, configPanelConstraints);
        pContainer.add(moduleSystemPanel);
        configPanelConstraints.weighty = 0.0;
        configPanelConstraints.gridx = 0;
        configPanelConstraints.gridy = 1;
        configPanelConstraints.insets = new Insets(10, 10, 10, 10);
        configPanelLayout.setConstraints(buttonPanel, configPanelConstraints);
        pContainer.add(buttonPanel);
        this.setContentPane(pContainer);
        this.updateValues();
        if (JAPModel.getDefaultView() == 2) {
            this.m_moduleSystem.selectNode(ANON_SERVICES_TAB);
        } else {
            this.m_moduleSystem.selectNode(DEBUG_TAB);
        }
        if (JAPModel.isSmallDisplay()) {
            this.setSize(240, 300);
            this.setLocation(0, 0);
        } else if (JAPModel.getInstance().isConfigWindowSizeSaved() && JAPModel.getInstance().getConfigSize() != null) {
            this.setSize(JAPModel.getInstance().getConfigSize());
        } else {
            this.doPack();
        }
        this.m_confUI.afterPack();
        this.m_moduleSystem.getConfigurationTree().setMinimumSize(this.m_moduleSystem.getConfigurationTree().getPreferredSize());
        this.m_moduleSystem.selectNode(UI_TAB);
        this.restoreLocation(JAPModel.getInstance().getConfigWindowLocation());
        this.addWindowListener(this);
        this.m_moduleSystem.initObservers();
        JAPModel.getInstance().addObserver(new Observer(){

            public void update(Observable a_observable, Object a_message) {
                if (a_message instanceof JAPModel.FontResize) {
                    Runnable run = new Runnable(){

                        public void run() {
                            SwingUtilities.updateComponentTreeUI(JAPConf.this.getContentPane());
                        }
                    };
                    if (SwingUtilities.isEventDispatchThread()) {
                        run.run();
                    } else {
                        SwingUtilities.invokeLater(run);
                    }
                }
            }
        });
    }

    public void windowClosed(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        this.cancelPressed();
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    protected synchronized void doPack() {
        boolean bError = false;
        boolean bRetry = false;
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                this.m_moduleSystem.revalidate();
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    public void run() {
                        JAPConf.this.m_moduleSystem.revalidate();
                    }
                });
            }
        }
        catch (Exception a_e) {
            LogHolder.log(3, LogType.GUI, a_e);
        }
        while (!bError) {
            this.pack();
            if (this.getSize().width < this.getSize().height) {
                LogHolder.log(3, LogType.GUI, "Could not pack config properly. Width is smaller than height! Width:" + this.getSize().width + " Height:" + this.getSize().height);
                bError = true;
            } else if (this.getSize().width > this.getScreenBounds().width || this.getSize().height > this.getScreenBounds().height) {
                LogHolder.log(3, LogType.GUI, "Packed config view with illegal size! " + this.getSize());
                bError = true;
            } else {
                JAPModel.getInstance().setConfigSize(this.getSize());
            }
            if (!bError) break;
            this.m_moduleSystem.revalidate();
            if (bRetry) {
                bError = false;
                bRetry = false;
                continue;
            }
            if (JAPModel.getInstance().getConfigSize() != null && JAPModel.getInstance().getConfigSize().width > 0 && JAPModel.getInstance().getConfigSize().height > 0) {
                this.setSize(JAPModel.getInstance().getConfigSize());
            } else {
                this.setSize(new Dimension(786, 545));
            }
            LogHolder.log(3, LogType.GUI, "Setting default config size to " + this.getSize());
            break;
        }
    }

    public void setVisible(boolean a_bVisible) {
        if (a_bVisible) {
            this.m_parentView.getViewIconified().switchBackToMainView();
            this.m_moduleSystem.createSavePoints();
        }
        super.setVisible(a_bVisible);
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.m_bttnHelp) {
            JAPHelp.getInstance().setContext(this.m_moduleSystem);
            JAPHelp.getInstance().loadCurrentContext();
        }
    }

    private JPanel buildMiscPanel() {
        JPanel p = new JPanel(new GridBagLayout());
        p.setBorder(new TitledBorder("Debugging"));
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 18;
        c.insets = new Insets(5, 5, 5, 5);
        JPanel panelLogTypes = new JPanel(new GridLayout(0, 1));
        this.m_cbLogTypes = new JCheckBox[LogType.getNumberOfLogTypes()];
        int[] availableLogTypes = LogType.getAvailableLogTypes();
        for (int i = 0; i < this.m_cbLogTypes.length; ++i) {
            this.m_cbLogTypes[i] = new JCheckBox(LogType.getLogTypeName(availableLogTypes[i]));
            if (i <= 0) continue;
            panelLogTypes.add(this.m_cbLogTypes[i]);
        }
        this.m_labelConfDebugTypes = new JAPMultilineLabel(JAPMessages.getString("ConfDebugTypes"));
        p.add((Component)this.m_labelConfDebugTypes, c);
        c.gridy = 1;
        p.add((Component)panelLogTypes, c);
        c.gridy = 2;
        c.gridwidth = 5;
        c.weightx = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 5, 0, 5);
        p.add((Component)new JSeparator(), c);
        this.m_cbShowDebugConsole = new JCheckBox(JAPMessages.getString("ConfDebugShowConsole"));
        this.m_cbShowDebugConsole.setSelected(JAPDebug.isShowConsole());
        JAPDebug.getInstance().addObserver(new Observer(){

            public void update(Observable a_observable, Object a_message) {
                JAPConf.this.m_cbShowDebugConsole.setSelected(false);
            }
        });
        this.m_cbShowDebugConsole.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                JAPDebug.showConsole(e.getStateChange() == 1, JAPController.getInstance().getViewWindow());
            }
        });
        c.gridy = 3;
        c.weighty = 0.0;
        c.insets = new Insets(5, 5, 5, 5);
        p.add((Component)this.m_cbShowDebugConsole, c);
        this.m_cbDebugToFile = new JCheckBox(JAPMessages.getString("ConfDebugFile"));
        this.m_cbDebugToFile.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                boolean b = JAPConf.this.m_cbDebugToFile.isSelected();
                JAPConf.this.m_bttnDebugFileNameSearch.setEnabled(b);
                JAPConf.this.m_tfDebugFileName.setEnabled(b);
            }
        });
        c.gridy = 4;
        c.weighty = 0.0;
        p.add((Component)this.m_cbDebugToFile, c);
        JPanel panelDebugFileName = new JPanel(new GridBagLayout());
        GridBagConstraints c1 = new GridBagConstraints();
        this.m_tfDebugFileName = new JTextField(20);
        c1.weightx = 1.0;
        c1.insets = new Insets(0, 5, 0, 5);
        c1.fill = 2;
        panelDebugFileName.add((Component)this.m_tfDebugFileName, c1);
        this.m_bttnDebugFileNameSearch = new JButton(JAPMessages.getString("ConfDebugFileNameSearch"));
        this.m_bttnDebugFileNameSearch.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int ret;
                JFileChooser fileChooser = new JFileChooser();
                String strCurrentFile = ms_JapConfInstance.m_tfDebugFileName.getText().trim();
                if (!strCurrentFile.equals("")) {
                    try {
                        fileChooser.setCurrentDirectory(new File(new File(strCurrentFile).getParent()));
                    }
                    catch (Exception e1) {
                        strCurrentFile = "";
                    }
                }
                if (JAPController.getInstance().isPortableMode() && strCurrentFile.equals("") && (strCurrentFile = AbstractOS.getInstance().getProperty("user.dir")) != null) {
                    fileChooser.setCurrentDirectory(new File(strCurrentFile));
                }
                if ((ret = GUIUtils.showMonitoredFileChooser(fileChooser, ms_JapConfInstance.getContentPane(), "__FILE_CHOOSER_OPEN")) == 0) {
                    try {
                        if (JAPController.getInstance().isPortableMode()) {
                            JAPConf.this.m_tfDebugFileName.setText(AbstractOS.toRelativePath(fileChooser.getSelectedFile().getCanonicalPath()));
                        } else {
                            JAPConf.this.m_tfDebugFileName.setText(fileChooser.getSelectedFile().getCanonicalPath());
                        }
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
        });
        c1.gridx = 1;
        c1.weightx = 0.0;
        panelDebugFileName.add((Component)this.m_bttnDebugFileNameSearch, c1);
        c.gridy = 5;
        c.weighty = 1.0;
        c.fill = 2;
        p.add((Component)panelDebugFileName, c);
        JPanel panelDebugLevels = new JPanel();
        this.m_sliderDebugLevel = new JSlider(1, 0, 7, 0);
        this.m_sliderDebugLevel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                Dictionary d = JAPConf.this.m_sliderDebugLevel.getLabelTable();
                for (int i = 0; i < LogLevel.getLevelCount(); ++i) {
                    ((JLabel)d.get(new Integer(i))).setEnabled(i <= JAPConf.this.m_sliderDebugLevel.getValue());
                }
            }
        });
        Hashtable<Integer, JLabel> ht = new Hashtable<Integer, JLabel>(LogLevel.getLevelCount(), 1.0f);
        for (int i = 0; i < LogLevel.getLevelCount(); ++i) {
            ht.put(new Integer(i), new JLabel(" " + LogLevel.getLevelName(i)));
        }
        this.m_sliderDebugLevel.setLabelTable(ht);
        this.m_sliderDebugLevel.setPaintLabels(true);
        this.m_sliderDebugLevel.setMajorTickSpacing(1);
        this.m_sliderDebugLevel.setMinorTickSpacing(1);
        this.m_sliderDebugLevel.setSnapToTicks(true);
        this.m_sliderDebugLevel.setPaintTrack(true);
        this.m_sliderDebugLevel.setPaintTicks(false);
        panelDebugLevels.add(this.m_sliderDebugLevel);
        c.gridheight = 2;
        c.gridwidth = 1;
        c.insets = new Insets(0, 10, 0, 10);
        c.gridx = 1;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 3;
        p.add((Component)new JSeparator(1), c);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 2;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_labelConfDebugLevel = new JAPMultilineLabel(JAPMessages.getString("ConfDebugLevels"));
        p.add((Component)this.m_labelConfDebugLevel, c);
        c.gridy = 1;
        c.weightx = 1.0;
        p.add((Component)panelDebugLevels, c);
        JPanel panelDebugDetailLevel = new JPanel();
        this.m_sliderDebugDetailLevel = new JSlider(1, 0, 3, LogHolder.getDetailLevel());
        this.m_sliderDebugDetailLevel.setPaintTicks(false);
        this.m_sliderDebugDetailLevel.setPaintLabels(true);
        this.m_sliderDebugDetailLevel.setMajorTickSpacing(1);
        this.m_sliderDebugDetailLevel.setMinorTickSpacing(1);
        this.m_sliderDebugDetailLevel.setSnapToTicks(true);
        this.m_sliderDebugDetailLevel.setPaintTrack(true);
        panelDebugDetailLevel.add(this.m_sliderDebugDetailLevel);
        c.gridheight = 2;
        c.gridwidth = 1;
        c.insets = new Insets(0, 10, 0, 10);
        c.gridx = 3;
        c.gridy = 0;
        c.weightx = 0.0;
        c.weighty = 0.0;
        c.fill = 3;
        p.add((Component)new JSeparator(1), c);
        c.gridheight = 1;
        c.gridwidth = 1;
        c.gridx = 4;
        c.gridy = 0;
        c.fill = 0;
        c.insets = new Insets(5, 5, 5, 5);
        this.m_labelConfDebugLevel = new JAPMultilineLabel(JAPMessages.getString(MSG_DETAILLEVEL));
        p.add((Component)this.m_labelConfDebugLevel, c);
        c.gridy = 1;
        c.weightx = 1.0;
        p.add((Component)panelDebugDetailLevel, c);
        return p;
    }

    void cancelPressed() {
        this.m_vecConfigChangesNeedRestart.removeAllElements();
        this.m_moduleSystem.processCancelPressedEvent();
        this.setVisible(false);
    }

    private boolean checkValues() {
        return true;
    }

    private void resetToDefault() {
        this.m_vecConfigChangesNeedRestart.removeAllElements();
        this.m_moduleSystem.processResetToDefaultsPressedEvent();
        this.m_cbShowDebugConsole.setSelected(false);
        this.m_sliderDebugLevel.setValue(4);
        for (int i = 0; i < this.m_cbLogTypes.length; ++i) {
            this.m_cbLogTypes[i].setSelected(true);
        }
        this.m_sliderDebugDetailLevel.setValue(3);
        this.m_cbDebugToFile.setSelected(false);
    }

    private boolean onOkPressed() {
        String strFilename = this.m_tfDebugFileName.getText().trim();
        if (!this.m_cbDebugToFile.isSelected()) {
            strFilename = null;
        }
        try {
            JAPDebug.setLogToFile(strFilename);
        }
        catch (IOException a_e) {
            JAPDialog.showErrorDialog((JAPDialog)this, JAPMessages.getString(MSG_COULD_NOT_OPEN_LOG), (Throwable)a_e);
            return false;
        }
        int[] availableLogTypes = LogType.getAvailableLogTypes();
        int logType = LogType.NUL;
        for (int i = 0; i < this.m_cbLogTypes.length; ++i) {
            logType |= this.m_cbLogTypes[i].isSelected() ? availableLogTypes[i] : LogType.NUL;
        }
        JAPDebug.getInstance().setLogType(logType);
        JAPDebug.getInstance().setLogLevel(this.m_sliderDebugLevel.getValue());
        LogHolder.setDetailLevel(this.m_sliderDebugDetailLevel.getValue());
        return true;
    }

    private void okPressed(final boolean a_bCloseConfiguration) {
        if (!this.checkValues()) {
            return;
        }
        this.m_vecConfigChangesNeedRestart.removeAllElements();
        if (!this.m_moduleSystem.processOkPressedEvent()) {
            this.m_vecConfigChangesNeedRestart.removeAllElements();
            return;
        }
        this.onOkPressed();
        this.resetAutomaticLocation(JAPModel.getInstance().isConfigWindowLocationSaved());
        if (this.m_vecConfigChangesNeedRestart.size() > 0) {
            int i;
            String strChanges = "<ul>";
            for (i = 0; i < this.m_vecConfigChangesNeedRestart.size(); ++i) {
                AbstractRestartNeedingConfigChange change = (AbstractRestartNeedingConfigChange)this.m_vecConfigChangesNeedRestart.elementAt(i);
                strChanges = strChanges + "<li>" + change.getName();
                if (change.getMessage() != null && change.getMessage().trim().length() > 0) {
                    strChanges = strChanges + "<br>" + change.getMessage();
                }
                strChanges = strChanges + "</li>";
            }
            if (JAPDialog.showYesNoDialog(this, JAPMessages.getString(MSG_NEED_RESTART, strChanges = strChanges + "</ul>"))) {
                for (i = 0; i < this.m_vecConfigChangesNeedRestart.size(); ++i) {
                    ((AbstractRestartNeedingConfigChange)this.m_vecConfigChangesNeedRestart.elementAt(i)).doChange();
                }
            } else {
                for (i = 0; i < this.m_vecConfigChangesNeedRestart.size(); ++i) {
                    ((AbstractRestartNeedingConfigChange)this.m_vecConfigChangesNeedRestart.elementAt(i)).doCancel();
                }
                this.m_vecConfigChangesNeedRestart.removeAllElements();
                return;
            }
        }
        Thread run = new Thread(new Runnable(){

            public void run() {
                JAPConf.this.m_Controller.saveConfigFile();
                if (a_bCloseConfiguration && !JAPConf.this.isRestartNeeded()) {
                    JAPConf.this.setVisible(false);
                }
                if (JAPConf.this.isRestartNeeded()) {
                    JAPController.goodBye(false);
                }
            }
        });
        run.setDaemon(true);
        run.start();
    }

    public void selectCard(String a_strSelectedCard, final Object a_value) {
        if (a_strSelectedCard != null) {
            if (a_strSelectedCard.equals(UI_TAB)) {
                this.m_moduleSystem.selectNode(UI_TAB);
                new Thread(new Runnable(){

                    public void run() {
                        JAPConf.this.m_confUI.chooseBrowserPath();
                    }
                }).start();
            } else if (a_strSelectedCard.equals(INFOSERVICE_TAB)) {
                this.m_moduleSystem.selectNode(INFOSERVICE_TAB);
                if (a_value != null && a_value instanceof Boolean && ((Boolean)a_value).booleanValue()) {
                    this.m_confInfoService.showSettingsPanel();
                }
            } else if (a_strSelectedCard.equals(NETWORK_TAB)) {
                this.m_moduleSystem.selectNode(NETWORK_TAB);
            } else if (a_strSelectedCard.equals(ANON_TAB)) {
                this.m_moduleSystem.selectNode(ANON_SERVICES_TAB);
                if (a_value instanceof MixCascade) {
                    this.m_confServices.selectAnonTab((MixCascade)a_value, false, false);
                } else if (a_value instanceof Boolean) {
                    this.m_confServices.selectAnonTab(null, (Boolean)a_value, false);
                } else {
                    this.m_confServices.selectAnonTab(null, false, true);
                }
            } else if (a_strSelectedCard.equals(PAYMENT_TAB)) {
                this.m_moduleSystem.selectNode(PAYMENT_TAB);
                if (a_value != null) {
                    new Thread(new Runnable(){

                        public void run() {
                            if (a_value instanceof Boolean && ((Boolean)a_value).booleanValue()) {
                                JAPConf.this.m_accountSettings.doCreateAccount(null);
                            } else if (a_value instanceof String) {
                                JAPConf.this.m_accountSettings.doCreateAccount((String)a_value);
                            } else if (a_value instanceof PayAccount) {
                                JAPConf.this.m_accountSettings.showOpenTransaction((PayAccount)a_value);
                            } else if (a_value instanceof Boolean && !((Boolean)a_value).booleanValue()) {
                                JAPConf.this.m_accountSettings.backupAccount();
                            }
                        }
                    }).start();
                }
            } else {
                this.m_moduleSystem.selectNode(a_strSelectedCard);
            }
        }
    }

    private synchronized void updateValues() {
        this.m_moduleSystem.processUpdateValuesEvent(true);
        this.m_cbShowDebugConsole.setSelected(JAPDebug.isShowConsole());
        int[] availableLogTypes = LogType.getAvailableLogTypes();
        for (int i = 0; i < this.m_cbLogTypes.length; ++i) {
            this.m_cbLogTypes[i].setSelected((JAPDebug.getInstance().getLogType() & availableLogTypes[i]) != 0);
        }
        this.m_sliderDebugLevel.setValue(JAPDebug.getInstance().getLogLevel());
        this.m_sliderDebugDetailLevel.setValue(LogHolder.getDetailLevel());
        boolean b = JAPDebug.isLogToFile();
        this.m_tfDebugFileName.setEnabled(b);
        this.m_bttnDebugFileNameSearch.setEnabled(b);
        this.m_cbDebugToFile.setSelected(b);
        if (b) {
            this.m_tfDebugFileName.setText(JAPDebug.getLogFilename());
        }
    }

    protected void addNeedRestart(AbstractRestartNeedingConfigChange a_change) {
        if (a_change != null) {
            this.m_vecConfigChangesNeedRestart.addElement(a_change);
        }
    }

    private boolean isRestartNeeded() {
        return this.m_vecConfigChangesNeedRestart.size() > 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static abstract class AbstractRestartNeedingConfigChange {
        public abstract String getName();

        public abstract void doChange();

        public void doCancel() {
        }

        public String getMessage() {
            return "";
        }
    }
}

