/*
 * Decompiled with CFR 0.152.
 */
package anon.proxy;

import anon.AnonChannel;
import anon.AnonServerDescription;
import anon.AnonService;
import anon.AnonServiceEventListener;
import anon.AnonServiceFactory;
import anon.client.AbstractAutoSwitchedMixCascadeContainer;
import anon.client.AnonClient;
import anon.client.BasicTrustModel;
import anon.client.ITrustModel;
import anon.client.TrustModel;
import anon.error.AccountEmptyException;
import anon.error.AnonServiceException;
import anon.error.ConnectionEstablishmentTimeoutException;
import anon.error.INotRecoverableException;
import anon.error.NotRecoverableException;
import anon.error.RecoverableExceptionContainer;
import anon.error.ServiceInterruptedException;
import anon.infoservice.AbstractMixCascadeContainer;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.infoservice.MixInfo;
import anon.mixminion.MixminionServiceDescription;
import anon.pay.PayAccountsFile;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.xml.NotRecoverableXMLError;
import anon.proxy.AbstractHTTPConnectionListener;
import anon.proxy.AnonProxyRequest;
import anon.proxy.DecompressionProxyCallback;
import anon.proxy.DirectProxy;
import anon.proxy.HTTPProxyCallback;
import anon.proxy.IProxyListener;
import anon.proxy.ProxyCallback;
import anon.proxy.ProxyCallbackHandler;
import anon.terms.TermsAndConditionConfirmation;
import anon.tor.TorAnonServerDescription;
import anon.transport.connection.IStreamConnection;
import anon.util.ExceptionVariable;
import anon.util.ObjectQueue;
import anon.util.SocketGuard;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public final class AnonProxy
implements AnonServiceEventListener {
    public static final int UNLIMITED_REQUESTS = Integer.MAX_VALUE;
    public static final int MIN_REQUESTS = 5;
    public static final int E_MIX_PROTOCOL_NOT_SUPPORTED = -10;
    public static final int E_SIGNATURE_CHECK_FIRSTMIX_FAILED = -22;
    public static final int E_SIGNATURE_CHECK_OTHERMIX_FAILED = -23;
    private static final int RECONNECT_INTERVAL = 800;
    private int m_maxRequests = Integer.MAX_VALUE;
    private int m_socketGuardTimeout = 0;
    private AnonClient m_Anon;
    private AnonService m_Tor;
    private AnonService m_Mixminion;
    private Vector m_anonServiceListener;
    private Thread threadRunOne;
    private Thread threadRunTwo;
    private final Object SYNC_THREAD_RUN = new Object();
    private Thread m_tInit;
    private ServerSocket m_socketListener;
    private ServerSocket m_socketListenerTwo;
    private IMutableProxyInterface m_proxyInterface = new IMutableProxyInterface.DummyMutableProxyInterface();
    private IProxyListener m_ProxyListener;
    private volatile int m_numChannels = 0;
    private boolean m_bReconnecting = false;
    private boolean m_bConnecting = false;
    private final Object THREAD_SYNC = new Object();
    private final Object SHUTDOWN_SYNC = new Object();
    private boolean m_bShuttingDown = false;
    private ProxyCallbackHandler m_callbackHandler;
    private final Object SYNC_CALLBACK_HANDLER = new Object();
    private final HTTPProxyCallback m_httpProxyCallback = new HTTPProxyCallback();
    private DecompressionProxyCallback m_decompressionProxyCallback = null;
    private TermsAndConditionConfirmation termsConfirmation = null;
    private AbstractMixCascadeContainer m_containerMixCascade = new DummyMixCascadeContainer();
    private Observer m_observer;
    private boolean m_bWeChanged = false;
    private TorAnonServerDescription m_currentTorParams;
    private MixminionServiceDescription m_currentMixminionParams;
    private boolean m_forwardedConnection;
    private int m_maxDummyTrafficInterval = 30000;
    private final Vector m_currentStartThreads = new Vector();
    static /* synthetic */ Class class$anon$infoservice$InfoServiceDBEntry;

    public AnonProxy(ServerSocket a_listener, TermsAndConditionConfirmation termsConfirmation, int a_socketTimeout) {
        this(a_listener, null, termsConfirmation);
    }

    public AnonProxy(DirectProxy a_directProxy, IMutableProxyInterface a_proxyInterface, TermsAndConditionConfirmation termsConfirmation) {
        this(a_directProxy, null, a_proxyInterface, termsConfirmation);
    }

    public AnonProxy(ServerSocket a_listener, IMutableProxyInterface a_proxyInterface, TermsAndConditionConfirmation termsConfirmation) {
        this(null, a_listener, a_proxyInterface, termsConfirmation);
    }

    private AnonProxy(DirectProxy a_directProxy, ServerSocket a_listener, IMutableProxyInterface a_proxyInterface, TermsAndConditionConfirmation termsConfirmation) {
        if ((a_directProxy == null || a_directProxy.getSocketListener() == null) && a_listener == null) {
            throw new IllegalArgumentException("Socket listener is null!");
        }
        if (a_directProxy != null && a_listener == null) {
            this.m_socketListener = a_directProxy.getSocketListener();
            this.m_socketListenerTwo = a_directProxy.getSocketListenerTwo();
        }
        if (this.m_socketListener == null) {
            this.m_socketListener = a_listener;
        }
        if (a_proxyInterface != null) {
            this.m_proxyInterface = a_proxyInterface;
        }
        this.m_Anon = new AnonClient(a_directProxy);
        this.m_Anon.setProxy(this.m_proxyInterface);
        this.setDummyTraffic(Integer.MAX_VALUE);
        this.m_forwardedConnection = false;
        this.m_anonServiceListener = new Vector();
        this.m_Anon.removeEventListeners();
        this.m_Anon.addEventListener(this);
        this.termsConfirmation = termsConfirmation;
    }

    public AnonProxy(DirectProxy a_directProxy, IStreamConnection a_proxyConnection, MixCascade a_currentService, int a_maxDummyTrafficInterval, TermsAndConditionConfirmation termsConfirmation) {
        if (a_directProxy == null) {
            throw new IllegalArgumentException("Socket listener is null!");
        }
        this.m_socketListener = a_directProxy.getSocketListener();
        this.m_socketListenerTwo = a_directProxy.getSocketListenerTwo();
        this.m_Anon = new AnonClient(a_directProxy, a_proxyConnection, a_currentService);
        this.m_forwardedConnection = true;
        this.m_maxDummyTrafficInterval = a_maxDummyTrafficInterval;
        this.setDummyTraffic(a_maxDummyTrafficInterval);
        this.m_anonServiceListener = new Vector();
        this.m_Anon.removeEventListeners();
        this.m_Anon.addEventListener(this);
        this.termsConfirmation = termsConfirmation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enableProxyCallback(ProxyCallback callback) {
        Object object = this.SYNC_CALLBACK_HANDLER;
        synchronized (object) {
            if (callback == null) {
                return;
            }
            if (this.m_callbackHandler == null) {
                LogHolder.log(4, LogType.NET, "No ProxyCallbackHandler activated: cannot process HTTP headers.");
                return;
            }
            this.m_callbackHandler.registerProxyCallback(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disableProxyCallback(ProxyCallback callback) {
        Object object = this.SYNC_CALLBACK_HANDLER;
        synchronized (object) {
            if (callback != null && this.m_callbackHandler != null) {
                this.m_callbackHandler.removeCallback(callback);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHTTPHeaderProcessingEnabled(boolean enable, boolean b_force_proxy_callback) {
        Object object = this.SYNC_CALLBACK_HANDLER;
        synchronized (object) {
            if (b_force_proxy_callback) {
                this.m_httpProxyCallback.blockHTTPListeners(!enable);
                if (this.m_callbackHandler == null) {
                    this.m_callbackHandler = new ProxyCallbackHandler();
                }
                this.enableProxyCallback(this.m_httpProxyCallback);
            } else if (enable) {
                if (this.m_callbackHandler == null) {
                    this.m_callbackHandler = new ProxyCallbackHandler();
                }
                this.enableProxyCallback(this.m_httpProxyCallback);
            } else {
                this.disableProxyCallback(this.m_httpProxyCallback);
                this.m_callbackHandler = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setHTTPDecompressionEnabled(boolean enable) {
        Object object = this.SYNC_CALLBACK_HANDLER;
        synchronized (object) {
            if (enable) {
                if (this.m_decompressionProxyCallback == null) {
                    this.m_decompressionProxyCallback = new DecompressionProxyCallback();
                }
                this.enableProxyCallback(this.m_decompressionProxyCallback);
            } else {
                this.disableProxyCallback(this.m_decompressionProxyCallback);
                this.m_decompressionProxyCallback = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void removeHTTPConnectionListener(AbstractHTTPConnectionListener listener) {
        if (listener == null) {
            return;
        }
        Object object = this.SYNC_CALLBACK_HANDLER;
        synchronized (object) {
            this.m_httpProxyCallback.removeHTTPConnectionListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHTTPConnectionListener(AbstractHTTPConnectionListener listener) {
        Object object = this.SYNC_CALLBACK_HANDLER;
        synchronized (object) {
            this.m_httpProxyCallback.addHTTPConnectionListener(listener);
            this.enableProxyCallback(this.m_httpProxyCallback);
        }
    }

    public MixCascade getMixCascade() {
        if (this.m_Anon.isConnected()) {
            return this.m_Anon.getCurrentService();
        }
        return this.m_containerMixCascade.getCurrentCascade();
    }

    public void setTorParams(TorAnonServerDescription newTorParams) {
        this.m_currentTorParams = newTorParams;
    }

    public TorAnonServerDescription getTorParams() {
        return this.m_currentTorParams;
    }

    public void setMixminionParams(MixminionServiceDescription newMixminionParams) {
        this.m_currentMixminionParams = newMixminionParams;
    }

    public MixminionServiceDescription getMixminionParams() {
        return this.m_currentMixminionParams;
    }

    public void setMaxConcurrentRequests(int a_maxRequests) {
        if (a_maxRequests > 5) {
            this.m_maxRequests = a_maxRequests;
        }
    }

    public int getMaxConcurrentRequests() {
        return this.m_maxRequests;
    }

    public void setDummyTraffic(int a_interval) {
        try {
            if (!this.m_forwardedConnection || this.m_maxDummyTrafficInterval < 0 || a_interval == Integer.MAX_VALUE) {
                this.m_Anon.setDummyTraffic(a_interval);
            } else if (a_interval >= 0) {
                this.m_Anon.setDummyTraffic(Math.min(a_interval, this.m_maxDummyTrafficInterval));
            } else {
                this.m_Anon.setDummyTraffic(this.m_maxDummyTrafficInterval);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void setInterfaceBlockTimeout(long a_msTimeout) {
        this.m_Anon.setInterfaceBlockTimout(a_msTimeout);
    }

    public void setDebug(boolean bDebug) {
        this.m_Anon.setDebug(bDebug);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.SHUTDOWN_SYNC;
        synchronized (object) {
            this.m_tInit = null;
            Object object2 = this.SYNC_THREAD_RUN;
            synchronized (object2) {
                if (this.threadRunOne == null && this.threadRunTwo == null) {
                    this.disconnected();
                    return;
                }
            }
            this.m_bShuttingDown = true;
            this.m_Anon.shutdown(true);
            if (this.m_Tor != null) {
                this.m_Tor.shutdown(true);
            }
            if (this.m_Mixminion != null) {
                this.m_Mixminion.shutdown(true);
            }
            while (this.threadRunOne.isAlive()) {
                try {
                    this.threadRunOne.interrupt();
                    this.threadRunOne.join(500L);
                }
                catch (InterruptedException e) {}
            }
            while (this.threadRunTwo != null && this.threadRunTwo.isAlive()) {
                try {
                    this.threadRunTwo.interrupt();
                    this.threadRunTwo.join(500L);
                }
                catch (InterruptedException e) {}
            }
            this.m_Tor = null;
            this.m_Mixminion = null;
            Object e = this.SYNC_THREAD_RUN;
            synchronized (e) {
                this.threadRunTwo = null;
                this.threadRunOne = null;
            }
            this.packetMixed(0L);
            while (this.m_bReconnecting) {
                try {
                    this.SHUTDOWN_SYNC.wait(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.disconnected();
            this.m_bShuttingDown = false;
            TrustModel.getCurrentTrustModel().unblockInterfacesFromDatabase();
            ListenerInterface.unblockInterfacesFromDatabase(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = AnonProxy.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry);
        }
    }

    AnonChannel createChannel(int type) throws ConnectException {
        if (type == 1) {
            if (this.m_Tor != null) {
                return this.m_Tor.createChannel(1);
            }
            if (this.getMixCascade().isSocks5Supported()) {
                return this.m_Anon.createChannel(1);
            }
            LogHolder.log(3, LogType.NET, "Received SOCKS request, but no SOCKS server is available.");
        } else {
            if (type == 0) {
                return this.m_Anon.createChannel(0);
            }
            if (type == 2) {
                return this.m_Anon.createChannel(2);
            }
            if (type == 3 && this.m_Mixminion != null) {
                return this.m_Mixminion.createChannel(3);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reconnect() {
        Object object = this.THREAD_SYNC;
        synchronized (object) {
            if (this.m_Anon.isConnected() || this.m_bShuttingDown || Thread.currentThread().isInterrupted()) {
                this.m_bConnecting = false;
                return;
            }
            if (!this.m_containerMixCascade.isReconnectedAutomatically()) {
                this.m_bConnecting = false;
                this.stop();
                this.THREAD_SYNC.notifyAll();
                return;
            }
            if (this.m_bReconnecting) {
                return;
            }
            this.m_bReconnecting = true;
            this.m_bConnecting = true;
            while (this.threadRunOne != null && this.m_containerMixCascade.isReconnectedAutomatically() && !this.m_Anon.isConnected() && !this.m_bShuttingDown && !Thread.currentThread().isInterrupted()) {
                boolean bReconnect = this.m_Anon.getCurrentService() == this.m_containerMixCascade.getCurrentCascade();
                this.m_bWeChanged = true;
                MixCascade cascade = this.m_containerMixCascade.getNextCascade();
                this.m_bWeChanged = false;
                int loglevel = 4;
                try {
                    if (cascade.getListenerInterface(0).getHost().equals("0.0.0.0")) {
                        loglevel = 6;
                    }
                }
                catch (Exception a_e) {
                    // empty catch block
                }
                LogHolder.log(loglevel, LogType.NET, "Try reconnect to AN.ON service. Connecting to " + cascade.getName() + "...");
                Thread tInit = null;
                ExceptionVariable retVar = new ExceptionVariable(null);
                if (!cascade.equals(this.m_Anon.getCurrentService())) {
                    this.fireCurrentServiceChanged(cascade);
                }
                tInit = this.startInitThread(retVar, cascade, true, bReconnect);
                this.joinInitThread(tInit, retVar);
                this.finishInitThread(cascade, retVar, tInit);
                if (retVar.get() == null) continue;
                LogHolder.log(5, LogType.NET, retVar.get());
                if (retVar.get() instanceof ServiceInterruptedException || !this.m_containerMixCascade.isReconnectedAutomatically() || !this.m_containerMixCascade.isServiceAutoSwitched() && retVar.get() instanceof AnonServiceException && retVar.get() instanceof INotRecoverableException && ((AnonServiceException)retVar.get()).getService() != AbstractAutoSwitchedMixCascadeContainer.INITIAL_DUMMY_SERVICE) {
                    if (!(retVar.get() instanceof INotRecoverableException)) break;
                    this.connectionError((AnonServiceException)retVar.get());
                    break;
                }
                try {
                    this.THREAD_SYNC.wait(800L);
                }
                catch (InterruptedException ex) {
                    break;
                }
            }
            Object object2 = this.SHUTDOWN_SYNC;
            synchronized (object2) {
                this.m_bReconnecting = false;
                this.m_bConnecting = false;
                if (!(this.m_bShuttingDown || this.threadRunOne != null && this.isConnected() || this.m_containerMixCascade.isReconnectedAutomatically())) {
                    this.stop();
                    this.THREAD_SYNC.notifyAll();
                }
                this.SHUTDOWN_SYNC.notify();
            }
            if (this.isConnected()) {
                this.m_containerMixCascade.reset();
            }
            return;
        }
    }

    public void setProxyListener(IProxyListener l) {
        this.m_ProxyListener = l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean interruptInit(Thread a_tInit) {
        Object object = this.THREAD_SYNC;
        synchronized (object) {
            if (a_tInit != null) {
                LogHolder.log(4, LogType.NET, "Interrupting init...", new InterruptedException());
                while (a_tInit.isAlive()) {
                    a_tInit.interrupt();
                    try {
                        a_tInit.join(100L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                LogHolder.log(4, LogType.NET, "Init was interrupted successfully!");
                return true;
            }
        }
        return false;
    }

    public int countStartThreads() {
        return this.m_currentStartThreads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(AbstractMixCascadeContainer a_newMixCascade) throws AnonServiceException {
        Object object = this.THREAD_SYNC;
        synchronized (object) {
            this.m_currentStartThreads.addElement(Thread.currentThread());
            this.m_bConnecting = true;
            try {
                this.start_internal(a_newMixCascade);
                this.m_bConnecting = false;
                this.m_currentStartThreads.removeElement(Thread.currentThread());
            }
            catch (AnonServiceException a_e) {
                this.m_currentStartThreads.removeElement(Thread.currentThread());
                throw a_e;
            }
            catch (RuntimeException a_e) {
                this.m_bConnecting = false;
                this.m_currentStartThreads.removeElement(Thread.currentThread());
                throw a_e;
            }
        }
    }

    private void joinInitThread(Thread tInit, ExceptionVariable retVar) {
        if (tInit == null) {
            return;
        }
        long lTimeout = System.currentTimeMillis() + (long)AnonClient.getLoginTimeout();
        while (tInit.isAlive()) {
            this.m_bConnecting = true;
            try {
                this.THREAD_SYNC.wait(100L);
            }
            catch (InterruptedException e) {
                this.interruptInit(tInit);
            }
            if (this.m_tInit == null) {
                this.interruptInit(tInit);
                continue;
            }
            if (lTimeout >= System.currentTimeMillis()) continue;
            this.interruptInit(tInit);
            retVar.set(new ConnectionEstablishmentTimeoutException(this.m_Anon.getCurrentService()));
        }
        this.m_bConnecting = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finishInitThread(MixCascade currentCascade, ExceptionVariable retVar, Thread tInit) {
        Object object = this.SHUTDOWN_SYNC;
        synchronized (object) {
            if (this.m_tInit == null || this.m_bShuttingDown) {
                if (this.m_Anon.isConnected()) {
                    this.m_Anon.shutdown(false);
                    this.disconnected();
                }
                retVar.set(new ServiceInterruptedException(currentCascade));
            }
            if (this.m_tInit == tInit) {
                this.m_tInit = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Thread startInitThread(final ExceptionVariable retVar, final MixCascade nextCascade, final boolean a_bKeepCurrentService, final boolean a_bReconnect) {
        Object object = this.SHUTDOWN_SYNC;
        synchronized (object) {
            if (this.m_bShuttingDown) {
                return null;
            }
            this.m_tInit = new Thread("AN.ON Connection establishment (key exchange etc.)"){

                public void run() {
                    if (nextCascade.isPayment() && PayAccountsFile.getInstance().getChargedAccount(nextCascade.getPIID()) == null) {
                        try {
                            PayAccountsFile.getInstance().signalAccountRequest(nextCascade);
                        }
                        catch (AccountEmptyException e1) {
                            retVar.set(e1);
                            return;
                        }
                    }
                    try {
                        AnonProxy.this.m_Anon.initialize(nextCascade, AnonProxy.this.m_containerMixCascade, AnonProxy.this.termsConfirmation, a_bReconnect);
                        if (a_bKeepCurrentService) {
                            AnonProxy.this.m_containerMixCascade.keepCurrentService(true);
                        }
                    }
                    catch (AnonServiceException a_e) {
                        retVar.set(a_e);
                    }
                }
            };
            this.m_tInit.start();
            Thread tInit = this.m_tInit;
            return tInit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start_internal(AbstractMixCascadeContainer a_newMixCascade) throws AnonServiceException {
        Thread tInit;
        MixCascade currentCascade;
        Object nextCascade;
        boolean bConnectionError = false;
        ExceptionVariable retVar = new ExceptionVariable(null);
        Object object = this.SHUTDOWN_SYNC;
        synchronized (object) {
            a_newMixCascade = a_newMixCascade == null ? new DummyMixCascadeContainer() : new EncapsulatedMixCascadeContainer(a_newMixCascade);
            if (this.m_observer != null) {
                this.m_containerMixCascade.deleteObserver(this.m_observer);
            }
            this.m_containerMixCascade = a_newMixCascade;
            this.m_bWeChanged = true;
            nextCascade = this.m_containerMixCascade.getNextCascade();
            currentCascade = nextCascade;
            if (this.m_bShuttingDown) {
                throw new ServiceInterruptedException(currentCascade);
            }
            this.m_bWeChanged = false;
            this.m_observer = new Observer(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void update(Observable a_observable, Object a_object) {
                    if (a_object != null && a_object instanceof MixCascade) {
                        Object object = AnonProxy.this.THREAD_SYNC;
                        synchronized (object) {
                            if (!AnonProxy.this.m_bWeChanged) {
                                new Thread(new Runnable(){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run() {
                                        Object object = AnonProxy.this.THREAD_SYNC;
                                        synchronized (object) {
                                            if (AnonProxy.this.m_tInit != null || AnonProxy.this.m_Anon.isConnected()) {
                                                try {
                                                    AnonProxy.this.m_containerMixCascade.keepCurrentService(true);
                                                    AnonProxy.this.start(AnonProxy.this.m_containerMixCascade);
                                                }
                                                catch (AnonServiceException a_ex) {
                                                    LogHolder.log(3, LogType.NET, "Switching service failed!", a_ex);
                                                }
                                            }
                                        }
                                    }
                                }).start();
                            }
                        }
                    }
                }
            };
            this.m_containerMixCascade.addObserver(this.m_observer);
            if (nextCascade != null) {
                if ((this.m_Anon.isConnected() || this.m_tInit != null) && this.m_Anon.getCurrentService().equals(nextCascade) && this.m_containerMixCascade.getTrustModel().isTrusted((MixCascade)nextCascade)) {
                    return;
                }
            } else {
                retVar.set(new NotRecoverableException(null, "Could not get cascade to connect. Next cascade is null!", -1));
                throw (AnonServiceException)retVar.get();
            }
            this.THREAD_SYNC.notifyAll();
            this.interruptInit(this.m_tInit);
            if (this.threadRunOne != null || this.threadRunTwo != null) {
                this.m_Anon.shutdown(false);
                if (this.threadRunTwo != null) {
                    while (this.threadRunTwo.isAlive()) {
                        try {
                            this.threadRunTwo.interrupt();
                            this.threadRunTwo.join(500L);
                        }
                        catch (InterruptedException e) {}
                    }
                    this.threadRunTwo = null;
                }
                if (this.threadRunOne != null) {
                    while (this.threadRunOne.isAlive()) {
                        try {
                            this.threadRunOne.interrupt();
                            this.threadRunOne.join(500L);
                        }
                        catch (InterruptedException e) {}
                    }
                    this.threadRunOne = null;
                }
            } else {
                this.m_Anon.shutdown(true);
            }
            LogHolder.log(5, LogType.NET, "Connecting to AN.ON service " + ((MixCascade)nextCascade).getName() + "...");
            this.m_numChannels = 0;
            this.fireCurrentServiceChanged((AnonServerDescription)nextCascade);
            tInit = this.startInitThread(retVar, (MixCascade)nextCascade, false, false);
        }
        this.joinInitThread(tInit, retVar);
        object = this.SHUTDOWN_SYNC;
        synchronized (object) {
            this.finishInitThread(currentCascade, retVar, tInit);
            nextCascade = this.SYNC_THREAD_RUN;
            synchronized (nextCascade) {
                if (this.threadRunOne != null || this.threadRunTwo != null) {
                    return;
                }
            }
            if (retVar.get() != null) {
                if (retVar.get() instanceof ServiceInterruptedException || !this.m_containerMixCascade.isReconnectedAutomatically() || !this.m_containerMixCascade.isServiceAutoSwitched() && retVar.get() instanceof AnonServiceException && retVar.get() instanceof INotRecoverableException && ((AnonServiceException)retVar.get()).getService() != AbstractAutoSwitchedMixCascadeContainer.INITIAL_DUMMY_SERVICE) {
                    this.connectionError((AnonServiceException)retVar.get());
                    throw (AnonServiceException)retVar.get();
                }
                bConnectionError = true;
            } else {
                this.m_containerMixCascade.keepCurrentService(true);
                this.m_containerMixCascade.reset();
            }
            LogHolder.log(6, LogType.NET, "AN.ON initialized");
            if (this.m_currentTorParams != null) {
                this.m_Tor = AnonServiceFactory.getAnonServiceInstance("TOR");
                this.m_Tor.setProxy(this.m_proxyInterface);
                try {
                    this.m_Tor.initialize(this.m_currentTorParams, null, this.termsConfirmation, false);
                    LogHolder.log(7, LogType.NET, "Tor initialized");
                }
                catch (AnonServiceException a_ex) {
                    LogHolder.log(2, LogType.NET, a_ex);
                }
            }
            if (this.m_currentMixminionParams != null) {
                this.m_Mixminion = AnonServiceFactory.getAnonServiceInstance("Mixminion");
                this.m_Mixminion.setProxy(this.m_proxyInterface);
                try {
                    this.m_Mixminion.initialize(this.m_currentMixminionParams, null, this.termsConfirmation, false);
                }
                catch (AnonServiceException a_ex) {
                    LogHolder.log(2, LogType.NET, a_ex);
                }
                LogHolder.log(7, LogType.NET, "Mixminion initialized");
            }
            Object object2 = this.SYNC_THREAD_RUN;
            synchronized (object2) {
                if (this.m_socketListenerTwo != null) {
                    this.threadRunTwo = new Thread((Runnable)new RunnableProxy(this.m_socketListenerTwo), "JAP - AnonProxy 2nd");
                    this.threadRunTwo.setDaemon(true);
                    this.threadRunTwo.start();
                }
                this.threadRunOne = new Thread((Runnable)new RunnableProxy(this.m_socketListener), "JAP - AnonProxy");
                this.threadRunOne.setDaemon(true);
                this.threadRunOne.start();
            }
        }
        if (bConnectionError) {
            if (this.m_containerMixCascade.isReconnectedAutomatically() && (this.m_containerMixCascade.isServiceAutoSwitched() || !(retVar.get() instanceof AnonServiceException) || !(retVar.get() instanceof INotRecoverableException) || ((AnonServiceException)retVar.get()).getService() == AbstractAutoSwitchedMixCascadeContainer.INITIAL_DUMMY_SERVICE) && retVar.get() instanceof INotRecoverableException) {
                if (retVar.get() instanceof NotRecoverableXMLError) {
                    retVar.set(((NotRecoverableXMLError)retVar.get()).getSource());
                } else {
                    retVar.set(new RecoverableExceptionContainer((AnonServiceException)retVar.get()));
                }
            }
            this.connectionError((AnonServiceException)retVar.get());
            throw (AnonServiceException)retVar.get();
        }
    }

    protected synchronized void decNumChannels() {
        --this.m_numChannels;
        if (this.m_ProxyListener != null) {
            this.m_ProxyListener.channelsChanged(this.m_numChannels);
        }
    }

    protected synchronized void incNumChannels() {
        ++this.m_numChannels;
        if (this.m_ProxyListener != null) {
            this.m_ProxyListener.channelsChanged(this.m_numChannels);
        }
    }

    protected synchronized void transferredBytes(long bytes, int protocolType) {
        if (this.m_ProxyListener != null) {
            this.m_ProxyListener.transferedBytes(bytes, protocolType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDisconnected() {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration e = this.m_anonServiceListener.elements();
            while (e.hasMoreElements()) {
                ((AnonServiceEventListener)e.nextElement()).disconnected();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnecting(AnonServerDescription a_serverDescription, boolean a_bIsReconnect) {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration e = this.m_anonServiceListener.elements();
            while (e.hasMoreElements()) {
                ((AnonServiceEventListener)e.nextElement()).connecting(a_serverDescription, a_bIsReconnect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireCurrentServiceChanged(AnonServerDescription a_serverDescription) {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration e = this.m_anonServiceListener.elements();
            while (e.hasMoreElements()) {
                ((AnonServiceEventListener)e.nextElement()).currentServiceChanged(a_serverDescription);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEstablished(AnonServerDescription a_serverDescription) {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            if (a_serverDescription instanceof MixCascade) {
                int iPremiumProbability = -1;
                boolean bCountRedirect = false;
                MixCascade cascade = (MixCascade)a_serverDescription;
                MixInfo lastMix = cascade.getMixInfo(cascade.getNumberOfMixes() - 1);
                if (lastMix != null && (iPremiumProbability = lastMix.getPremiumProbability()) >= 0) {
                    bCountRedirect = true;
                } else {
                    PaymentInstanceDBEntry pi = null;
                    if (cascade.isPayment()) {
                        pi = cascade.getPaymentInstance();
                    }
                    if (pi == null || pi.isTest()) {
                        bCountRedirect = true;
                    }
                }
                this.m_httpProxyCallback.resetRedirect(iPremiumProbability, bCountRedirect);
            }
            Enumeration e = this.m_anonServiceListener.elements();
            while (e.hasMoreElements()) {
                ((AnonServiceEventListener)e.nextElement()).connectionEstablished(a_serverDescription);
            }
        }
    }

    public void connecting(AnonServerDescription a_serverDescription, boolean a_bIsReconnect) {
        LogHolder.log(4, LogType.NET, "AnonProxy is connecting to: " + a_serverDescription);
        this.fireConnecting(a_serverDescription, a_bIsReconnect);
    }

    public void currentServiceChanged(AnonServerDescription a_serverDescription) {
        LogHolder.log(1, LogType.NET, "AnonProxy changed current service to '" + a_serverDescription + "'.");
        this.fireCurrentServiceChanged(a_serverDescription);
    }

    public void connectionEstablished(AnonServerDescription a_serverDescription) {
        LogHolder.log(1, LogType.NET, "AnonProxy received connectionEstablished to '" + a_serverDescription + "'.");
        this.fireConnectionEstablished(a_serverDescription);
    }

    public void disconnected() {
        LogHolder.log(1, LogType.NET, "AnonProxy was disconnected from service " + this.m_containerMixCascade.getCurrentCascade().getName() + ".");
        this.fireDisconnected();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionError(AnonServiceException a_e) {
        LogHolder.log(a_e != null && a_e.getService() == AbstractAutoSwitchedMixCascadeContainer.INITIAL_DUMMY_SERVICE ? 7 : (a_e != null && a_e instanceof ServiceInterruptedException ? 4 : 3), LogType.NET, "AnonProxy received connectionError", a_e, 1);
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration e = this.m_anonServiceListener.elements();
            while (e.hasMoreElements()) {
                ((AnonServiceEventListener)e.nextElement()).connectionError(a_e);
            }
        }
        new Thread(new Runnable(){

            public void run() {
                AnonProxy.this.reconnect();
            }
        }, "Connection error reconnect thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addEventListener(AnonServiceEventListener l) {
        if (l == null) {
            LogHolder.log(4, LogType.NET, "Tried to add NULL listener to AnonProxy.");
            return;
        }
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration e = this.m_anonServiceListener.elements();
            while (e.hasMoreElements()) {
                if (!l.equals(e.nextElement())) continue;
                return;
            }
            this.m_anonServiceListener.addElement(l);
        }
    }

    public synchronized void removeEventListener(AnonServiceEventListener l) {
        this.m_anonServiceListener.removeElement(l);
    }

    public boolean isConnected() {
        return this.m_Anon.isConnected();
    }

    public boolean isConnecting() {
        return this.m_bReconnecting || this.m_bConnecting;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void packetMixed(long a_totalBytes) {
        if (this.isConnected() || a_totalBytes == 0L) {
            Vector vector = this.m_anonServiceListener;
            synchronized (vector) {
                Enumeration e = this.m_anonServiceListener.elements();
                while (e.hasMoreElements()) {
                    ((AnonServiceEventListener)e.nextElement()).packetMixed(a_totalBytes);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChainErrorSignaled(AnonServiceException a_e) {
        LogHolder.log(3, LogType.NET, a_e);
        this.m_containerMixCascade.keepCurrentService(false);
        this.m_Anon.shutdown(false);
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration e = this.m_anonServiceListener.elements();
            while (e.hasMoreElements()) {
                ((AnonServiceEventListener)e.nextElement()).dataChainErrorSignaled(a_e);
            }
        }
        this.reconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrityErrorSignaled(AnonServiceException a_e) {
        Vector vector = this.m_anonServiceListener;
        synchronized (vector) {
            Enumeration e = this.m_anonServiceListener.elements();
            while (e.hasMoreElements()) {
                ((AnonServiceEventListener)e.nextElement()).integrityErrorSignaled(a_e);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class EncapsulatedMixCascadeContainer
    extends AbstractMixCascadeContainer {
        private AbstractMixCascadeContainer m_mixCascadeContainer;

        public void addObserver(Observer a_observer) {
            this.m_mixCascadeContainer.addObserver(a_observer);
        }

        public void deleteObserver(Observer a_observer) {
            this.m_mixCascadeContainer.deleteObserver(a_observer);
        }

        public void deleteObservers() {
            this.m_mixCascadeContainer.deleteObservers();
        }

        public EncapsulatedMixCascadeContainer(AbstractMixCascadeContainer a_mixCascadeContainer) {
            this.m_mixCascadeContainer = a_mixCascadeContainer;
        }

        public void reset() {
            this.m_mixCascadeContainer.reset();
        }

        public ITrustModel getTrustModel() {
            return this.m_mixCascadeContainer.getTrustModel();
        }

        public MixCascade getNextRandomCascade() {
            return this.m_mixCascadeContainer.getNextRandomCascade();
        }

        public MixCascade getNextCascade() {
            return this.m_mixCascadeContainer.getNextCascade();
        }

        public MixCascade getCurrentCascade() {
            return this.m_mixCascadeContainer.getCurrentCascade();
        }

        public void keepCurrentService(boolean a_bKeepCurrentCascade) {
            this.m_mixCascadeContainer.keepCurrentService(a_bKeepCurrentCascade);
        }

        public boolean isServiceAutoSwitched() {
            return this.m_mixCascadeContainer.isServiceAutoSwitched();
        }

        public boolean isReconnectedAutomatically() {
            return !AnonProxy.this.m_forwardedConnection && this.m_mixCascadeContainer.isReconnectedAutomatically();
        }
    }

    private class DummyMixCascadeContainer
    extends AbstractMixCascadeContainer {
        public MixCascade getNextCascade() {
            return null;
        }

        public MixCascade getNextRandomCascade() {
            return null;
        }

        public MixCascade getCurrentCascade() {
            return null;
        }

        public void keepCurrentService(boolean a_bKeepCurrentCascade) {
        }

        public boolean isServiceAutoSwitched() {
            return false;
        }

        public boolean isReconnectedAutomatically() {
            return false;
        }

        public ITrustModel getTrustModel() {
            return new BasicTrustModel();
        }
    }

    private class RunnableProxy
    implements Runnable {
        private ServerSocket m_serverSocket;

        public RunnableProxy(ServerSocket a_serverSocket) {
            this.m_serverSocket = a_serverSocket;
        }

        public void run() {
            int oldTimeOut;
            block20: {
                oldTimeOut = 0;
                LogHolder.log(7, LogType.NET, "AnonProxy is running as Thread");
                try {
                    oldTimeOut = this.m_serverSocket.getSoTimeout();
                }
                catch (Exception e) {
                    if (!AnonProxy.this.m_bShuttingDown) break block20;
                    return;
                }
            }
            try {
                this.m_serverSocket.setSoTimeout(2000);
            }
            catch (Exception e1) {
                LogHolder.log(7, LogType.NET, "Could not set accept time out!", e1);
            }
            if (AnonProxy.this.m_bShuttingDown) {
                try {
                    this.m_serverSocket.setSoTimeout(oldTimeOut);
                }
                catch (Exception e4) {
                    // empty catch block
                }
                return;
            }
            OpenSocketRequester requester = new OpenSocketRequester(AnonProxy.this, AnonProxy.this.THREAD_SYNC);
            Thread requesterThread = new Thread((Runnable)requester, requester.getClass().getName());
            requesterThread.start();
            block16: while (true) {
                try {
                    while (!Thread.currentThread().isInterrupted() && !AnonProxy.this.m_bShuttingDown) {
                        if (!AnonProxy.this.isConnected()) {
                            Thread.sleep(250L);
                            continue;
                        }
                        SocketGuard socket = null;
                        try {
                            socket = new SocketGuard(this.m_serverSocket.accept(), AnonProxy.this.m_socketGuardTimeout);
                        }
                        catch (InterruptedIOException e) {
                            continue;
                        }
                        try {
                            socket.setSoTimeout(0);
                            requester.pushSocket(socket);
                            continue block16;
                        }
                        catch (SocketException soex) {
                            socket = null;
                            LogHolder.log(3, LogType.NET, "Could not set non-Blocking mode for Channel-Socket!", soex);
                        }
                    }
                    break;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.NET, e);
                    break;
                }
            }
            try {
                this.m_serverSocket.setSoTimeout(oldTimeOut);
            }
            catch (Exception e4) {
                // empty catch block
            }
            requesterThread.interrupt();
            requester.close();
            try {
                requesterThread.join();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
            LogHolder.log(4, LogType.NET, "JAPAnonProxyServer stopped socket: " + this.m_serverSocket.toString());
        }
    }

    private class OpenSocketRequester
    implements Runnable {
        private ObjectQueue m_socketQueue = new ObjectQueue();
        private AnonProxy m_proxy;
        private Object m_syncObject;
        private boolean m_bIsClosed = false;

        public OpenSocketRequester(AnonProxy a_proxy, Object a_syncObject) {
            this.m_proxy = a_proxy;
            this.m_syncObject = a_syncObject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void pushSocket(SocketGuard clientSocket) {
            ObjectQueue objectQueue = this.m_socketQueue;
            synchronized (objectQueue) {
                this.m_socketQueue.push(clientSocket);
                this.m_socketQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            this.m_bIsClosed = true;
            ObjectQueue objectQueue = this.m_socketQueue;
            synchronized (objectQueue) {
                this.m_socketQueue.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (!Thread.currentThread().isInterrupted() && !this.m_bIsClosed) {
                if (this.m_socketQueue.getSize() > 0 && AnonProxyRequest.getNrOfRequests() < AnonProxy.this.m_maxRequests) {
                    try {
                        new AnonProxyRequest(this.m_proxy, (SocketGuard)this.m_socketQueue.pop(), this.m_syncObject, AnonProxy.this.m_callbackHandler);
                    }
                    catch (Exception e) {
                        LogHolder.log(3, LogType.NET, e);
                    }
                    continue;
                }
                try {
                    ObjectQueue e = this.m_socketQueue;
                    synchronized (e) {
                        if (AnonProxyRequest.getNrOfRequests() >= AnonProxy.this.m_maxRequests) {
                            this.m_socketQueue.wait(100L);
                        } else {
                            this.m_socketQueue.wait();
                        }
                    }
                }
                catch (InterruptedException ex) {
                    // empty catch block
                    break;
                }
            }
            LogHolder.log(6, LogType.NET, "Open socket thread stopped.");
        }
    }

    public class RoundRobinRequestQueue {
        private final Vector vecPriorityRequests = new Vector();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addPriority(AnonProxyRequest a_request) {
            Vector vector = this.vecPriorityRequests;
            synchronized (vector) {
                if (!this.vecPriorityRequests.contains(a_request)) {
                    this.vecPriorityRequests.addElement(a_request);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removePriority(AnonProxyRequest a_request) {
            Vector vector = this.vecPriorityRequests;
            synchronized (vector) {
                this.vecPriorityRequests.removeElement(a_request);
            }
        }

        public boolean isSlowDownUploads() {
            return this.vecPriorityRequests.size() > 0;
        }

        public boolean isBlockUploads() {
            return AnonProxy.this.m_Anon.isSendingControlMessage();
        }
    }
}

