/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion;

import anon.crypto.JAPCertificate;
import anon.crypto.PKCS12;
import anon.crypto.RSAKeyPair;
import anon.crypto.Validity;
import anon.crypto.X509DistinguishedName;
import anon.crypto.tinytls.TinyTLS;
import anon.mixminion.FirstMMRConnectionThread;
import anon.mixminion.Mixminion;
import anon.mixminion.message.MixMinionCryptoUtil;
import anon.mixminion.mmrdescription.MMRDescription;
import anon.util.ByteArrayUtil;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Random;
import logging.LogHolder;
import logging.LogType;

public class FirstMMRConnection {
    private static String OP_NAME = "JAPClient";
    private TinyTLS m_tinyTLS;
    private MMRDescription m_description;
    private InputStream m_istream;
    private OutputStream m_ostream;
    private String m_protocol = "MMTP 0.3";
    private boolean m_bIsClosed = true;
    private long m_inittimeout = 30000L;
    private Mixminion m_Mixminion;
    private int m_blocksize = 1024;

    public FirstMMRConnection(MMRDescription d, Mixminion a_Mixminion) {
        this.m_description = d;
        this.m_Mixminion = a_Mixminion;
    }

    public MMRDescription getMMRDescription() {
        return this.m_description;
    }

    public boolean isClosed() {
        return this.m_bIsClosed;
    }

    private boolean sending(byte[] send, String sendtype) throws IOException {
        try {
            String s = sendtype + "\r\n";
            byte[] init = new byte[6];
            init = s.getBytes();
            int MESSAGE_LEN = 32768;
            if (send.length != MESSAGE_LEN) {
                return false;
            }
            byte[] message = send;
            byte[] hash2 = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(message, sendtype.getBytes()));
            this.m_ostream.write(init);
            for (int i = 0; i < message.length; i += this.m_blocksize) {
                this.m_ostream.write(message, i, this.m_blocksize);
            }
            this.m_ostream.write(hash2);
            this.m_ostream.flush();
            LogHolder.log(7, LogType.MISC, "MMRConnection " + this.m_description.getName() + " - Send a packet");
            if (sendtype.equals("SEND")) {
                return this.receive(message, "RECEIVED");
            }
            if (sendtype.equals("JUNK")) {
                return this.receive(message, "RECEIVED JUNK");
            }
            return false;
        }
        catch (InterruptedIOException ex) {
            return false;
        }
    }

    public boolean send(byte[] message) throws IOException {
        try {
            this.connect();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String sendtype = "SEND";
        boolean send = this.sending(message, sendtype);
        this.close();
        return send;
    }

    public boolean sendMessage(byte[] message) throws IOException {
        String sendtype = "SEND";
        return this.sending(message, sendtype);
    }

    public boolean sendJunk() throws IOException {
        String sendtype = "JUNK";
        int MESSAGE_LEN = 32768;
        byte[] message = new byte[MESSAGE_LEN];
        new Random().nextBytes(message);
        return this.sending(message, sendtype);
    }

    private boolean receive(byte[] message, String type) {
        try {
            BufferedInputStream in_buffstream = new BufferedInputStream(this.m_istream);
            byte[] receivedanswer = new byte[10];
            in_buffstream.read(receivedanswer, 0, 10);
            String str_receivedanswer = new String(receivedanswer, 0, 8);
            byte[] receivedhash = new byte[20];
            in_buffstream.read(receivedhash, 0, 20);
            if (str_receivedanswer.equals("RECEIVED")) {
                byte[] messagehash = new byte[20];
                messagehash = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(message, type.getBytes()));
                if (ByteArrayUtil.equal(receivedhash, messagehash)) {
                    LogHolder.log(7, LogType.MISC, "MMRConnection " + this.m_description.getName() + " - Packet Transmission succeeded. Valid checksum.");
                    return true;
                }
                LogHolder.log(7, LogType.MISC, "MMRConnection " + this.m_description.getName() + " - Packet Transmission failed. Invalid checksum.");
                System.out.println("Hash nicht korrekt!");
                return false;
            }
            if (str_receivedanswer.equals("REJECTED")) {
                byte[] messagehash = new byte[20];
                messagehash = MixMinionCryptoUtil.hash(ByteArrayUtil.conc(message, "REJECTED".getBytes()));
                if (ByteArrayUtil.equal(receivedhash, messagehash)) {
                    LogHolder.log(7, LogType.MISC, "MMRConnection " + this.m_description.getName() + " - Packet Transmission rejected. Valid checksum.");
                    return false;
                }
                LogHolder.log(7, LogType.MISC, "MMRConnection " + this.m_description.getName() + " - Packet Transmission rejected. Invalid checksum.");
                return false;
            }
            LogHolder.log(7, LogType.MISC, "MMRConnection " + this.m_description.getName() + " - Packet Transmission failed. Invalid server answer.");
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    private void createClientCert() {
        try {
            RSAKeyPair kp = RSAKeyPair.getInstance(new BigInteger(new byte[]{1, 0, 1}), new SecureRandom(), 1024, 100);
            JAPCertificate cert = JAPCertificate.getInstance(new X509DistinguishedName("CN=" + OP_NAME), kp, new Validity(Calendar.getInstance(), 1));
            RSAKeyPair kp2 = RSAKeyPair.getInstance(new BigInteger(new byte[]{1, 0, 1}), new SecureRandom(), 1024, 100);
            PKCS12 pkcs12cert = new PKCS12(new X509DistinguishedName("CN=" + OP_NAME + " <identity>"), kp2, new Validity(Calendar.getInstance(), 1));
            JAPCertificate cert1 = cert.sign(pkcs12cert);
            JAPCertificate cert2 = JAPCertificate.getInstance(pkcs12cert.getX509Certificate());
            this.m_tinyTLS.setClientCertificate(new JAPCertificate[]{cert1, cert2}, kp.getPrivate());
        }
        catch (Exception ex) {
            LogHolder.log(7, LogType.TOR, "Error while creating Certificates. Certificates are not used.");
        }
    }

    public void connect() throws Exception {
        FirstMMRConnectionThread forct = new FirstMMRConnectionThread(this.m_description.getAddress(), this.m_description.getPort(), this.m_inittimeout, this.m_Mixminion.getProxy().getProxyInterface(false).getProxyInterface());
        this.m_tinyTLS = forct.getConnection();
        this.m_tinyTLS.checkRootCertificate(false);
        this.createClientCert();
        this.m_tinyTLS.startHandshake();
        this.m_ostream = this.m_tinyTLS.getOutputStream();
        this.m_istream = this.m_tinyTLS.getInputStream();
        BufferedInputStream in_buffstream = new BufferedInputStream(this.m_istream);
        this.m_tinyTLS.setSoTimeout(30000);
        this.m_ostream.write(this.m_protocol.concat("\r\n").getBytes());
        byte[] receivedanswer = new byte[10];
        in_buffstream.read(receivedanswer, 0, 10);
        String str_receivedanswer = new String(receivedanswer, 0, 8);
        if (str_receivedanswer.equals(this.m_protocol)) {
            LogHolder.log(7, LogType.MISC, "MMRConnection " + this.m_description.getName() + " - Protocol supported: " + this.m_protocol);
            this.m_bIsClosed = false;
        } else {
            LogHolder.log(7, LogType.MISC, "MMRConnection " + this.m_description.getName() + " - Protocol not supported: " + this.m_protocol);
            this.close();
            this.m_bIsClosed = true;
        }
    }

    public void close() {
        try {
            if (!this.m_bIsClosed) {
                this.m_bIsClosed = true;
                this.m_tinyTLS.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

