/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls.ciphersuites;

import anon.crypto.JAPCertificate;
import anon.crypto.MyRandom;
import anon.crypto.tinytls.TLSException;
import anon.crypto.tinytls.TLSPlaintextRecord;
import anon.crypto.tinytls.keyexchange.Key_Exchange;
import anon.util.ByteArrayUtil;
import java.math.BigInteger;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.macs.HMac;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;

public abstract class CipherSuite {
    private byte[] m_ciphersuitecode;
    protected String m_ciphersuitename = "Name not set";
    private Key_Exchange m_keyexchangealgorithm = null;
    private JAPCertificate m_servercertificate = null;
    protected CBCBlockCipher m_decryptcipher;
    protected CBCBlockCipher m_encryptcipher;
    private HMac m_hmacInput = new HMac(new SHA1Digest());
    private HMac m_hmacOutput = new HMac(new SHA1Digest());
    private MyRandom m_Random;
    protected long m_writesequenznumber;
    protected long m_readsequenznumber;
    protected byte[] m_clientwritekey = null;
    protected byte[] m_clientmacsecret = null;
    protected byte[] m_clientwriteIV = null;
    protected byte[] m_serverwritekey = null;
    protected byte[] m_servermacsecret = null;
    protected byte[] m_serverwriteIV = null;

    public CipherSuite(byte[] code) throws TLSException {
        if (code.length != 2) {
            throw new TLSException("wrong CipherSuiteCode ");
        }
        this.m_ciphersuitecode = code;
        this.m_writesequenznumber = 0L;
        this.m_readsequenznumber = 0L;
        this.m_Random = new MyRandom();
    }

    protected void setKeyExchangeAlgorithm(Key_Exchange ke) {
        this.m_keyexchangealgorithm = ke;
    }

    public Key_Exchange getKeyExchangeAlgorithm() {
        return this.m_keyexchangealgorithm;
    }

    public void setServerCertificate(JAPCertificate cert) {
        this.m_servercertificate = cert;
    }

    public byte[] getCipherSuiteCode() {
        return this.m_ciphersuitecode;
    }

    public void processClientKeyExchange(BigInteger dh_y) {
        this.m_keyexchangealgorithm.processClientKeyExchange(dh_y);
        this.calculateKeys(this.m_keyexchangealgorithm.calculateKeys(), false);
        this.m_hmacInput.init(new KeyParameter(this.m_servermacsecret));
        this.m_hmacOutput.init(new KeyParameter(this.m_clientmacsecret));
    }

    public byte[] calculateClientKeyExchange() throws TLSException {
        byte[] b = this.m_keyexchangealgorithm.calculateClientKeyExchange();
        this.calculateKeys(this.m_keyexchangealgorithm.calculateKeys(), true);
        this.m_hmacInput.init(new KeyParameter(this.m_servermacsecret));
        this.m_hmacOutput.init(new KeyParameter(this.m_clientmacsecret));
        return b;
    }

    public void processServerFinished(TLSPlaintextRecord msg, byte[] handshakemessages) throws TLSException {
        this.decode(msg);
        this.m_keyexchangealgorithm.processServerFinished(msg.getData(), msg.getLength(), handshakemessages);
    }

    public void encode(TLSPlaintextRecord msg) {
        int i;
        int dataLen = msg.getLength();
        byte[] dataBuff = msg.getData();
        byte[] header = msg.getHeader();
        this.m_hmacOutput.reset();
        this.m_hmacOutput.update(ByteArrayUtil.inttobyte(this.m_writesequenznumber, 8), 0, 8);
        ++this.m_writesequenznumber;
        this.m_hmacOutput.update(header, 0, header.length);
        this.m_hmacOutput.update(dataBuff, 0, dataLen);
        this.m_hmacOutput.doFinal(dataBuff, dataLen);
        int paddingsize = this.m_Random.nextInt(240);
        paddingsize += this.m_encryptcipher.getBlockSize() - ((dataLen += this.m_hmacOutput.getMacSize()) + 1 + paddingsize) % this.m_encryptcipher.getBlockSize();
        for (i = 0; i < paddingsize + 1; ++i) {
            dataBuff[dataLen++] = (byte)paddingsize;
        }
        for (i = 0; i < dataLen; i += this.m_encryptcipher.getBlockSize()) {
            this.m_encryptcipher.processBlock(dataBuff, i, dataBuff, i);
        }
        msg.setLength(dataLen);
    }

    public void decode(TLSPlaintextRecord msg) throws TLSException {
        int dataLen = msg.getLength();
        byte[] dataBuff = msg.getData();
        if (dataLen % this.m_decryptcipher.getBlockSize() != 0 || dataLen < this.m_hmacInput.getMacSize()) {
            throw new TLSException("wrong payload len!");
        }
        for (int i = 0; i < dataLen; i += this.m_decryptcipher.getBlockSize()) {
            this.m_decryptcipher.processBlock(dataBuff, i, dataBuff, i);
        }
        int len = dataLen - this.m_hmacInput.getMacSize() - 1;
        byte paddingbyte = dataBuff[dataLen - 1];
        int paddinglength = paddingbyte & 0xFF;
        if (paddinglength > dataLen - 2) {
            throw new TLSException("wrong Padding len detected", 2, 51);
        }
        for (int i = dataLen - 1; i > dataLen - paddinglength - 2; --i) {
            if (dataBuff[i] == paddingbyte) continue;
            throw new TLSException("wrong Padding detected", 2, 51);
        }
        msg.setLength(len -= paddinglength);
        this.m_hmacInput.reset();
        this.m_hmacInput.update(ByteArrayUtil.inttobyte(this.m_readsequenznumber, 8), 0, 8);
        ++this.m_readsequenznumber;
        byte[] header = msg.getHeader();
        this.m_hmacInput.update(header, 0, header.length);
        this.m_hmacInput.update(dataBuff, 0, len);
        byte[] mac = new byte[this.m_hmacInput.getMacSize()];
        this.m_hmacInput.doFinal(mac, 0);
        if (!ByteArrayUtil.equal(dataBuff, len, mac, 0, mac.length)) {
            throw new TLSException("Wrong MAC detected!!!", 2, 20);
        }
    }

    protected abstract void calculateKeys(byte[] var1, boolean var2);

    public String toString() {
        return this.m_ciphersuitename;
    }
}

