/*
 * Decompiled with CFR 0.152.
 */
package anon.tor;

import anon.crypto.JAPCertificate;
import anon.crypto.MyRSAPublicKey;
import anon.crypto.MyRandom;
import anon.crypto.PKCS12;
import anon.crypto.RSAKeyPair;
import anon.crypto.Validity;
import anon.crypto.X509DistinguishedName;
import anon.crypto.tinytls.TinyTLS;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.ImmutableProxyInterface;
import anon.tor.Circuit;
import anon.tor.FirstOnionRouterConnectionThread;
import anon.tor.Tor;
import anon.tor.cells.Cell;
import anon.tor.ordescription.ORDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class FirstOnionRouterConnection
implements Runnable {
    private static String OP_NAME = "JAPClient";
    private TinyTLS m_tinyTLS;
    private ORDescriptor m_description;
    private Thread m_readDataLoop = null;
    private InputStream m_istream;
    private OutputStream m_ostream;
    private Hashtable m_Circuits;
    private volatile boolean m_bRun = false;
    private boolean m_bIsClosed = true;
    private MyRandom m_rand;
    private Object m_oSendSync;
    private long m_inittimeout = 30000L;
    private Tor m_Tor;
    private RSAKeyPair m_keypairIdentityKey;

    public FirstOnionRouterConnection(ORDescriptor d, Tor a_Tor) {
        this.m_description = d;
        this.m_rand = new MyRandom(new SecureRandom());
        this.m_oSendSync = new Object();
        this.m_Tor = a_Tor;
    }

    public ORDescriptor getORDescription() {
        return this.m_description;
    }

    public boolean isClosed() {
        return this.m_bIsClosed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Cell cell) throws IOException {
        Object object = this.m_oSendSync;
        synchronized (object) {
            while (true) {
                try {
                    this.m_ostream.write(cell.getCellData());
                    this.m_ostream.flush();
                    LogHolder.log(7, LogType.TOR, "OnionConnection " + this.m_description.getName() + " Send a cell");
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                break;
            }
        }
    }

    private boolean dispatchCell(Cell cell) {
        try {
            int cid = cell.getCircuitID();
            LogHolder.log(7, LogType.MISC, "OnionProxy read() Tor Cell - Circuit: " + cid + " Type: " + cell.getCommand());
            Circuit circuit = (Circuit)this.m_Circuits.get(new Integer(cid));
            if (circuit != null) {
                circuit.dispatchCell(cell);
            } else {
                this.m_Circuits.remove(new Integer(cid));
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public synchronized void connect() throws Exception {
        IMutableProxyInterface pi = this.m_Tor.getProxy();
        ImmutableProxyInterface proxy = null;
        if (pi != null) {
            proxy = pi.getProxyInterface(false).getProxyInterface();
        }
        FirstOnionRouterConnectionThread forct = new FirstOnionRouterConnectionThread(this.m_description.getAddress(), this.m_description.getPort(), this.m_inittimeout, proxy);
        this.m_tinyTLS = forct.getConnection();
        this.m_tinyTLS.setRootKey(this.m_description.getSigningKey());
        try {
            RSAKeyPair kp = RSAKeyPair.getInstance(new BigInteger(new byte[]{1, 0, 1}), new SecureRandom(), 1024, 100);
            JAPCertificate cert = JAPCertificate.getInstance(new X509DistinguishedName("CN=" + OP_NAME), kp, new Validity(Calendar.getInstance(), 1));
            this.m_keypairIdentityKey = RSAKeyPair.getInstance(new BigInteger(new byte[]{1, 0, 1}), new SecureRandom(), 1024, 100);
            PKCS12 pkcs12cert = new PKCS12(new X509DistinguishedName("CN=" + OP_NAME + " <identity>"), this.m_keypairIdentityKey, new Validity(Calendar.getInstance(), 1));
            JAPCertificate cert1 = cert.sign(pkcs12cert);
            JAPCertificate cert2 = JAPCertificate.getInstance(pkcs12cert.getX509Certificate());
            this.m_tinyTLS.setClientCertificate(new JAPCertificate[]{cert1, cert2}, kp.getPrivate());
        }
        catch (Exception ex) {
            LogHolder.log(7, LogType.TOR, "Error while creating Certificates. Certificates are not used.");
        }
        this.m_tinyTLS.setSoTimeout(30000);
        this.m_tinyTLS.startHandshake();
        this.m_istream = this.m_tinyTLS.getInputStream();
        this.m_ostream = this.m_tinyTLS.getOutputStream();
        this.m_Circuits = new Hashtable();
        this.m_tinyTLS.setSoTimeout(1000);
        this.start();
        this.m_bIsClosed = false;
    }

    public synchronized Circuit createCircuit(Vector onionRouters) {
        int circid = 0;
        try {
            int iMSB = 32768;
            if (this.m_description.getSigningKey().getModulus().compareTo(((MyRSAPublicKey)this.m_keypairIdentityKey.getPublic()).getModulus()) > 0) {
                iMSB = 0;
            }
            do {
                circid = this.m_rand.nextInt(Short.MAX_VALUE);
            } while (this.m_Circuits.containsKey(new Integer(circid |= iMSB)) && circid != 0);
            Circuit circ = new Circuit(circid, this, onionRouters);
            this.m_Circuits.put(new Integer(circid), circ);
            circ.create();
            return circ;
        }
        catch (Exception e) {
            this.m_Circuits.remove(new Integer(circid));
            return null;
        }
    }

    private void start() {
        if (this.m_readDataLoop == null) {
            this.m_bRun = true;
            this.m_readDataLoop = new Thread((Runnable)this, "FirstOnionRouterConnection - " + this.m_description.getName());
            this.m_readDataLoop.setDaemon(true);
            this.m_readDataLoop.start();
        }
    }

    public void run() {
        Cell cell = null;
        byte[] buff = new byte[512];
        int readPos = 0;
        while (this.m_bRun) {
            readPos = 0;
            while (readPos < 512 && this.m_bRun) {
                int ret = 0;
                try {
                    ret = this.m_istream.read(buff, readPos, 512 - readPos);
                }
                catch (InterruptedIOException ioe) {
                    continue;
                }
                catch (IOException io) {
                    break;
                }
                if (ret <= 0) break;
                readPos += ret;
            }
            if (readPos != 512) {
                this.closedByPeer();
                return;
            }
            LogHolder.log(7, LogType.TOR, "OnionConnection " + this.m_description.getName() + " received a Cell!");
            cell = Cell.createCell(buff);
            if (cell == null) {
                LogHolder.log(0, LogType.TOR, "OnionConnection " + this.m_description.getName() + " dont know about this Cell!");
            }
            if (cell != null && this.dispatchCell(cell)) continue;
            this.closedByPeer();
            return;
        }
    }

    private void stop() throws IOException {
        if (this.m_readDataLoop != null && this.m_bRun) {
            try {
                this.m_bRun = false;
                this.m_readDataLoop.interrupt();
                this.m_readDataLoop.join();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.m_readDataLoop = null;
    }

    public synchronized void close() {
        try {
            if (!this.m_bIsClosed) {
                this.m_bIsClosed = true;
                this.stop();
                this.m_tinyTLS.close();
                Enumeration enumer = this.m_Circuits.elements();
                while (enumer.hasMoreElements()) {
                    ((Circuit)enumer.nextElement()).close();
                }
                this.m_Circuits.clear();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closedByPeer() {
        if (this.m_bIsClosed) {
            return;
        }
        FirstOnionRouterConnection firstOnionRouterConnection = this;
        synchronized (firstOnionRouterConnection) {
            try {
                this.stop();
                this.m_tinyTLS.close();
                Enumeration enumer = this.m_Circuits.elements();
                while (enumer.hasMoreElements()) {
                    ((Circuit)enumer.nextElement()).destroyedByPeer();
                }
                this.m_Circuits.clear();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_bIsClosed = true;
        }
    }

    protected void notifyCircuitClosed(Circuit circ) {
        this.m_Circuits.remove(new Integer(circ.getCircID()));
    }
}

