/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.IAnonUDPChannel;
import anon.client.UDPPacketStreamDesynchronisationException;
import anon.client.UDPPacketToLargeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class AbstractAnonUDPChannel
implements IAnonUDPChannel {
    private AnonUDPChannelOutputStream m_anonUDPOutputStream = null;
    private AnonUDPChannelInputStream m_anonUDPInputStream = new AnonUDPChannelInputStream();
    protected String m_strDstHost;
    protected int m_iDstPort;
    protected int m_iSrcPort;

    protected AbstractAnonUDPChannel() {
        this.m_anonUDPOutputStream = new AnonUDPChannelOutputStream();
    }

    public void setDestination(String host, int port) {
        this.m_strDstHost = host;
        this.m_iDstPort = port;
    }

    public void setSourcePort(int port) {
        this.m_iSrcPort = port;
    }

    public void setSentAutoFlushDelay(int msAutoFlushDelay) {
    }

    public void writePacket(byte[] payload) throws IOException {
        this.writePacket(payload, 0, payload.length);
    }

    public InputStream getInputStream() {
        return this.m_anonUDPInputStream;
    }

    public OutputStream getOutputStream() {
        return this.m_anonUDPOutputStream;
    }

    public abstract /* synthetic */ void writePacket(byte[] var1, int var2, int var3) throws IOException;

    public abstract /* synthetic */ int readPacket(byte[] var1, int var2, int var3) throws IOException, UDPPacketStreamDesynchronisationException, UDPPacketToLargeException;

    public abstract /* synthetic */ boolean isClosed();

    public abstract /* synthetic */ void close();

    public abstract /* synthetic */ int getOutputBlockSize();

    private class AnonUDPChannelInputStream
    extends InputStream {
        private int m_iRemainingLenUDPPayload = -1;
        private int m_iOffsetUDPPayload;
        private byte[] m_arOneByte = new byte[1];
        private byte[] m_buffUDPPacket = new byte[65535];

        AnonUDPChannelInputStream() {
        }

        public void close() throws IOException {
        }

        public synchronized int read() throws IOException {
            int ret = this.read(this.m_arOneByte, 0, 1);
            if (ret != 1) {
                return -1;
            }
            return this.m_arOneByte[0];
        }

        public synchronized int read(byte[] b) throws IOException {
            return this.read(b, 0, b.length);
        }

        public synchronized int read(byte[] b, int off, int len) throws IOException {
            int ret = -1;
            if (this.m_iRemainingLenUDPPayload <= 0) {
                this.m_iRemainingLenUDPPayload = AbstractAnonUDPChannel.this.readPacket(this.m_buffUDPPacket, 0, this.m_buffUDPPacket.length);
                if (this.m_iRemainingLenUDPPayload < 0) {
                    return -1;
                }
                this.m_iOffsetUDPPayload = 0;
            }
            ret = Math.min(this.m_iRemainingLenUDPPayload, len);
            System.arraycopy(this.m_buffUDPPacket, this.m_iOffsetUDPPayload, b, off, ret);
            if (ret >= 0) {
                this.m_iRemainingLenUDPPayload -= ret;
                this.m_iOffsetUDPPayload += ret;
            }
            return ret;
        }
    }

    private class AnonUDPChannelOutputStream
    extends OutputStream {
        AnonUDPChannelOutputStream() {
        }

        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        public void write(int b) throws IOException {
            byte[] bar = new byte[]{(byte)b};
            this.write(bar, 0, 1);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            AbstractAnonUDPChannel.this.writePacket(b, off, len);
        }

        public void flush() throws IOException {
        }

        public void close() throws IOException {
        }
    }
}

